/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.net.ConnectException;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.CatchUpChannelPool;
import org.neo4j.helpers.AdvertisedSocketAddress;

public class CatchUpChannelPoolTest {
    @Test
    public void shouldReUseAChannelThatWasReleased() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        pool.release((CatchUpChannelPool.Channel)channelA);
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        Assert.assertSame((Object)channelA, (Object)channelB);
    }

    @Test
    public void shouldCreateANewChannelIfFirstChannelIsDisposed() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        pool.dispose((CatchUpChannelPool.Channel)channelA);
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        Assert.assertNotSame((Object)channelA, (Object)channelB);
    }

    @Test
    public void shouldCreateANewChannelIfFirstChannelIsStillActive() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        Assert.assertNotSame((Object)channelA, (Object)channelB);
    }

    @Test
    public void shouldCleanUpOnClose() throws Exception {
        CatchUpChannelPool pool = new CatchUpChannelPool(TestChannel::new);
        TestChannel channelA = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        TestChannel channelB = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        TestChannel channelC = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        pool.release((CatchUpChannelPool.Channel)channelA);
        pool.release((CatchUpChannelPool.Channel)channelC);
        TestChannel channelD = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(2));
        TestChannel channelE = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(2));
        TestChannel channelF = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(2));
        pool.close();
        Assert.assertTrue((boolean)channelA.closed);
        Assert.assertTrue((boolean)channelB.closed);
        Assert.assertTrue((boolean)channelC.closed);
        Assert.assertTrue((boolean)channelD.closed);
        Assert.assertTrue((boolean)channelE.closed);
        Assert.assertTrue((boolean)channelF.closed);
    }

    @Test
    public void shouldFailWithExceptionIsChannelIsNotActive() {
        CatchUpChannelPool pool = new CatchUpChannelPool(advertisedSocketAddress -> new TestChannel((AdvertisedSocketAddress)advertisedSocketAddress, false));
        try {
            pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        }
        catch (Exception e) {
            Assert.assertEquals(ConnectException.class, e.getClass());
            Assert.assertEquals((Object)"Unable to connect to localhost:1", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void shouldCheckConnectionOnIdleChannelFirst() {
        CatchUpChannelPool pool = new CatchUpChannelPool((Function)new Function<AdvertisedSocketAddress, TestChannel>(){
            boolean firstIsActive = true;

            @Override
            public TestChannel apply(AdvertisedSocketAddress address) {
                TestChannel testChannel = new TestChannel(address, this.firstIsActive);
                this.firstIsActive = false;
                return testChannel;
            }
        });
        TestChannel channel = null;
        try {
            channel = (TestChannel)pool.acquire(CatchUpChannelPoolTest.localAddress(1));
            Assert.assertNotNull((Object)channel);
        }
        catch (Exception e) {
            Assert.fail((String)"Not expected exception");
        }
        channel.isActive = false;
        pool.release((CatchUpChannelPool.Channel)channel);
        try {
            pool.acquire(CatchUpChannelPoolTest.localAddress(1));
        }
        catch (Exception e) {
            Assert.assertEquals(ConnectException.class, e.getClass());
            Assert.assertEquals((Object)"Unable to connect to localhost:1", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    private static AdvertisedSocketAddress localAddress(int port) {
        return new AdvertisedSocketAddress("localhost", port);
    }

    private static class TestChannel
    implements CatchUpChannelPool.Channel {
        private final AdvertisedSocketAddress address;
        private boolean isActive;
        private boolean closed;

        TestChannel(AdvertisedSocketAddress address, boolean isActive) {
            this.address = address;
            this.isActive = isActive;
        }

        TestChannel(AdvertisedSocketAddress address) {
            this(address, true);
        }

        public AdvertisedSocketAddress destination() {
            return this.address;
        }

        public void connect() {
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void close() {
            this.closed = true;
        }
    }
}

