/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamingProtocol;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.causalclustering.catchup.storecopy.StoreResourceStreamFactory;
import org.neo4j.causalclustering.catchup.storecopy.StoreStreamingProcess;
import org.neo4j.cursor.RawCursor;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.util.Cursors;

public class StoreStreamingProcessTest {
    private final StoreFileStreamingProtocol protocol = (StoreFileStreamingProtocol)Mockito.mock(StoreFileStreamingProtocol.class);
    private final CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
    private final StoreResourceStreamFactory resourceStream = (StoreResourceStreamFactory)Mockito.mock(StoreResourceStreamFactory.class);
    private final ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    private final Supplier<CheckPointer> checkPointerSupplier = () -> this.checkPointer;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private StoreCopyCheckPointMutex mutex = new StoreCopyCheckPointMutex((ReadWriteLock)this.lock);

    @Test
    public void shouldPerformSuccessfulStoreCopyProcess() throws Exception {
        StoreStreamingProcess process = new StoreStreamingProcess(this.protocol, this.checkPointerSupplier, this.mutex, this.resourceStream);
        ImmediateEventExecutor eventExecutor = ImmediateEventExecutor.INSTANCE;
        Promise completionPromise = eventExecutor.newPromise();
        long lastCheckpointedTxId = 1000L;
        RawCursor resources = Cursors.rawCursorOf((Object[])new StoreResource[0]);
        Mockito.when((Object)this.checkPointer.tryCheckPoint((TriggerInfo)ArgumentMatchers.any())).thenReturn((Object)lastCheckpointedTxId);
        Mockito.when((Object)this.checkPointer.lastCheckPointedTransactionId()).thenReturn((Object)lastCheckpointedTxId);
        Mockito.when((Object)this.protocol.end(this.ctx, StoreCopyFinishedResponse.Status.SUCCESS)).thenReturn((Object)completionPromise);
        Mockito.when((Object)this.resourceStream.create()).thenReturn((Object)resources);
        process.perform(this.ctx);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.protocol, this.checkPointer});
        ((CheckPointer)inOrder.verify((Object)this.checkPointer)).tryCheckPoint((TriggerInfo)ArgumentMatchers.any());
        ((StoreFileStreamingProtocol)inOrder.verify((Object)this.protocol)).end(this.ctx, StoreCopyFinishedResponse.Status.SUCCESS);
        inOrder.verifyNoMoreInteractions();
        Assert.assertEquals((long)1L, (long)this.lock.getReadLockCount());
        completionPromise.setSuccess(null);
        Assert.assertEquals((long)0L, (long)this.lock.getReadLockCount());
    }

    @Test
    public void shouldSignalFailure() {
        StoreStreamingProcess process = new StoreStreamingProcess(this.protocol, this.checkPointerSupplier, this.mutex, this.resourceStream);
        process.fail(this.ctx, StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH);
        ((StoreFileStreamingProtocol)Mockito.verify((Object)this.protocol)).end(this.ctx, StoreCopyFinishedResponse.Status.E_STORE_ID_MISMATCH);
    }
}

