/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.explorer;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.explorer.ClusterSafetyViolations;
import org.neo4j.causalclustering.core.consensus.explorer.ClusterState;
import org.neo4j.causalclustering.core.consensus.explorer.ComparableRaftState;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.helpers.collection.Iterators;

public class ClusterSafetyViolationsTest {
    @Test
    public void shouldRecogniseInconsistentCommittedContent() throws Exception {
        ClusterState clusterState = new ClusterState(Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1)}));
        clusterState.states.get((Object)RaftTestMember.member((int)0)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)1)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)0)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        clusterState.states.get((Object)RaftTestMember.member((int)1)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(3))});
        this.commit(clusterState, RaftTestMember.member(0), 0L);
        this.commit(clusterState, RaftTestMember.member(1), 0L);
        Assert.assertFalse((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
        this.commit(clusterState, RaftTestMember.member(0), 1L);
        this.commit(clusterState, RaftTestMember.member(1), 1L);
        Assert.assertTrue((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
    }

    @Test
    public void shouldRecogniseInconsistentTerm() throws Exception {
        ClusterState clusterState = new ClusterState(Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1)}));
        clusterState.states.get((Object)RaftTestMember.member((int)0)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)1)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)0)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        clusterState.states.get((Object)RaftTestMember.member((int)1)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        this.commit(clusterState, RaftTestMember.member(0), 0L);
        this.commit(clusterState, RaftTestMember.member(1), 0L);
        Assert.assertFalse((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
        this.commit(clusterState, RaftTestMember.member(0), 1L);
        this.commit(clusterState, RaftTestMember.member(1), 1L);
        Assert.assertTrue((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
    }

    @Test
    public void shouldRecogniseSomeMembersBeingInconsistent() throws Exception {
        ClusterState clusterState = new ClusterState(Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)}));
        clusterState.states.get((Object)RaftTestMember.member((int)0)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)1)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)2)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        clusterState.states.get((Object)RaftTestMember.member((int)0)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        clusterState.states.get((Object)RaftTestMember.member((int)1)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        clusterState.states.get((Object)RaftTestMember.member((int)2)).entryLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        this.commit(clusterState, RaftTestMember.member(0), 0L);
        this.commit(clusterState, RaftTestMember.member(1), 0L);
        this.commit(clusterState, RaftTestMember.member(2), 0L);
        Assert.assertFalse((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
        this.commit(clusterState, RaftTestMember.member(0), 1L);
        this.commit(clusterState, RaftTestMember.member(1), 1L);
        Assert.assertFalse((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
        this.commit(clusterState, RaftTestMember.member(2), 1L);
        Assert.assertTrue((boolean)ClusterSafetyViolations.inconsistentCommittedLogEntries(clusterState));
    }

    @Test
    public void shouldRecogniseTwoLeadersInTheSameTerm() throws Exception {
        ClusterState clusterState = new ClusterState(Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)}));
        clusterState.states.get((Object)RaftTestMember.member((int)0)).term = 21L;
        clusterState.states.get((Object)RaftTestMember.member((int)1)).term = 21L;
        clusterState.states.get((Object)RaftTestMember.member((int)2)).term = 21L;
        clusterState.roles.put(RaftTestMember.member(0), Role.LEADER);
        clusterState.roles.put(RaftTestMember.member(1), Role.LEADER);
        clusterState.roles.put(RaftTestMember.member(2), Role.FOLLOWER);
        Assert.assertTrue((boolean)ClusterSafetyViolations.multipleLeadersInSameTerm(clusterState));
    }

    @Test
    public void shouldRecogniseTwoLeadersInDifferentTerms() throws Exception {
        ClusterState clusterState = new ClusterState(Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)}));
        clusterState.states.get((Object)RaftTestMember.member((int)0)).term = 21L;
        clusterState.states.get((Object)RaftTestMember.member((int)1)).term = 22L;
        clusterState.states.get((Object)RaftTestMember.member((int)2)).term = 21L;
        clusterState.roles.put(RaftTestMember.member(0), Role.LEADER);
        clusterState.roles.put(RaftTestMember.member(1), Role.LEADER);
        clusterState.roles.put(RaftTestMember.member(2), Role.FOLLOWER);
        Assert.assertFalse((boolean)ClusterSafetyViolations.multipleLeadersInSameTerm(clusterState));
    }

    private void commit(ClusterState clusterState, MemberId member, long commitIndex) throws IOException {
        ComparableRaftState state = clusterState.states.get(member);
        Outcome outcome = new Outcome(clusterState.roles.get(member), (ReadableRaftState)state);
        outcome.setCommitIndex(commitIndex);
        state.update(outcome);
    }
}

