/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class DummyRaftableContentSerializer
extends SafeChannelMarshal<ReplicatedContent> {
    private static final int REPLICATED_INTEGER_TYPE = 0;
    private static final int REPLICATED_STRING_TYPE = 1;

    public void marshal(ReplicatedContent content, WritableChannel channel) throws IOException {
        if (content instanceof ReplicatedInteger) {
            channel.put((byte)0);
            channel.putInt(((ReplicatedInteger)content).get());
        } else if (content instanceof ReplicatedString) {
            String value = ((ReplicatedString)content).get();
            byte[] stringBytes = value.getBytes();
            channel.put((byte)1);
            channel.putInt(stringBytes.length);
            channel.put(stringBytes, stringBytes.length);
        } else {
            throw new IllegalArgumentException("Unknown content type: " + content);
        }
    }

    protected ReplicatedContent unmarshal0(ReadableChannel channel) throws IOException {
        byte type = channel.get();
        switch (type) {
            case 0: {
                return ReplicatedInteger.valueOf(channel.getInt());
            }
            case 1: {
                int length = channel.getInt();
                byte[] bytes = new byte[length];
                channel.get(bytes, length);
                return ReplicatedString.valueOf(new String(bytes));
            }
        }
        throw new IllegalArgumentException("Unknown content type: " + type);
    }
}

