/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.MonitoredRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftLogAppendIndexMonitor;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftLogCommitIndexMonitor;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitoredRaftLogTest {
    @Test
    public void shouldMonitorAppendIndexAndCommitIndex() throws Exception {
        Monitors monitors = new Monitors();
        StubRaftLogAppendIndexMonitor appendMonitor = new StubRaftLogAppendIndexMonitor();
        monitors.addMonitorListener((Object)appendMonitor, new String[0]);
        StubRaftLogCommitIndexMonitor commitMonitor = new StubRaftLogCommitIndexMonitor();
        monitors.addMonitorListener((Object)commitMonitor, new String[0]);
        MonitoredRaftLog log = new MonitoredRaftLog((RaftLog)new InMemoryRaftLog(), monitors);
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        Assert.assertEquals((long)1L, (long)appendMonitor.appendIndex());
        Assert.assertEquals((long)0L, (long)commitMonitor.commitIndex());
        log.truncate(1L);
        Assert.assertEquals((long)0L, (long)appendMonitor.appendIndex());
    }

    private static class StubRaftLogAppendIndexMonitor
    implements RaftLogAppendIndexMonitor {
        private long appendIndex;

        private StubRaftLogAppendIndexMonitor() {
        }

        public long appendIndex() {
            return this.appendIndex;
        }

        public void appendIndex(long appendIndex) {
            this.appendIndex = appendIndex;
        }
    }

    private static class StubRaftLogCommitIndexMonitor
    implements RaftLogCommitIndexMonitor {
        private long commitIndex;

        private StubRaftLogCommitIndexMonitor() {
        }

        public long commitIndex() {
            return this.commitIndex;
        }

        public void commitIndex(long commitIndex) {
            this.commitIndex = commitIndex;
        }
    }
}

