/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkFlushableByteBuf;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class RaftContentByteBufferMarshalTest {
    private MemberId memberId = new MemberId(UUID.randomUUID());

    @Test
    public void shouldSerializeMemberSet() throws Exception {
        CoreReplicatedContentMarshal serializer = new CoreReplicatedContentMarshal();
        MemberIdSet in = new MemberIdSet(Iterators.asSet((Object[])new MemberId[]{new MemberId(UUID.randomUUID()), new MemberId(UUID.randomUUID())}));
        ByteBuf buf = Unpooled.buffer();
        this.assertMarshalingEquality(serializer, buf, (ReplicatedContent)in);
    }

    @Test
    public void shouldSerializeTransactionRepresentation() throws Exception {
        CoreReplicatedContentMarshal serializer = new CoreReplicatedContentMarshal();
        ArrayList<IndexCommand.AddNodeCommand> commands = new ArrayList<IndexCommand.AddNodeCommand>();
        IndexCommand.AddNodeCommand addNodeCommand = new IndexCommand.AddNodeCommand();
        addNodeCommand.init(0, 0L, 0, (Object)0);
        commands.add(addNodeCommand);
        byte[] extraHeader = new byte[]{};
        PhysicalTransactionRepresentation txIn = new PhysicalTransactionRepresentation(commands);
        txIn.setHeader(extraHeader, -1, -1, 0L, 0L, 0L, 0);
        ReplicatedTransaction in = ReplicatedTransactionFactory.createImmutableReplicatedTransaction((TransactionRepresentation)txIn);
        ByteBuf buf = Unpooled.buffer();
        serializer.marshal((ReplicatedContent)in, (WritableChannel)new NetworkFlushableByteBuf(buf));
        ReplicatedTransaction out = (ReplicatedTransaction)serializer.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buf));
        TransactionRepresentation txOut = ReplicatedTransactionFactory.extractTransactionRepresentation((ReplicatedTransaction)out, (byte[])extraHeader);
        Assert.assertEquals((Object)in, (Object)out);
        Assert.assertEquals((Object)txIn, (Object)txOut);
    }

    @Test
    public void txSerializationShouldNotResultInExcessZeroes() {
        byte[] extraHeader = new byte[]{};
        PhysicalTransactionRepresentation txIn = new PhysicalTransactionRepresentation(new ArrayList());
        txIn.setHeader(extraHeader, -1, -1, 0L, 0L, 0L, 0);
        ReplicatedTransaction in = ReplicatedTransactionFactory.createImmutableReplicatedTransaction((TransactionRepresentation)txIn);
        Assert.assertEquals((long)40L, (long)in.getTxBytes().length);
    }

    @Test
    public void shouldSerializeIdRangeRequest() throws Exception {
        CoreReplicatedContentMarshal serializer = new CoreReplicatedContentMarshal();
        ReplicatedIdAllocationRequest in = new ReplicatedIdAllocationRequest(this.memberId, IdType.NODE, 100L, 200);
        ByteBuf buf = Unpooled.buffer();
        this.assertMarshalingEquality(serializer, buf, (ReplicatedContent)in);
    }

    private void assertMarshalingEquality(CoreReplicatedContentMarshal marshal, ByteBuf buffer, ReplicatedContent replicatedTx) throws IOException, EndOfStreamException {
        marshal.marshal(replicatedTx, (WritableChannel)new NetworkFlushableByteBuf(buffer));
        MatcherAssert.assertThat((Object)marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer)), (Matcher)CoreMatchers.equalTo((Object)replicatedTx));
    }
}

