/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.util.concurrent.ThreadLocalRandom;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.VerifyingRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public abstract class RaftLogVerificationIT {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private VerifyingRaftLog raftLog;

    protected abstract RaftLog createRaftLog() throws Throwable;

    protected abstract long operations();

    @Before
    public void before() throws Throwable {
        this.raftLog = new VerifyingRaftLog(this.createRaftLog());
    }

    @After
    public void after() throws Throwable {
        this.raftLog.verify();
    }

    @Test
    public void verifyAppend() throws Throwable {
        int i = 0;
        while ((long)i < this.operations()) {
            this.raftLog.append(new RaftLogEntry((long)(i * 3), (ReplicatedContent)ReplicatedInteger.valueOf(i * 7)));
            ++i;
        }
    }

    @Test
    public void verifyAppendWithIntermittentTruncation() throws Throwable {
        int i = 0;
        while ((long)i < this.operations()) {
            this.raftLog.append(new RaftLogEntry((long)(i * 3), (ReplicatedContent)ReplicatedInteger.valueOf(i * 7)));
            if (i > 0 && i % 13 == 0) {
                this.raftLog.truncate(this.raftLog.appendIndex() - 10L);
            }
            ++i;
        }
    }

    @Test
    public void randomAppendAndTruncate() throws Exception {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int i = 0;
        while ((long)i < this.operations()) {
            int finalAppendIndex;
            int appendIndex = finalAppendIndex = tlr.nextInt(10) + 1;
            while (appendIndex-- > 0) {
                this.raftLog.append(new RaftLogEntry((long)i, (ReplicatedContent)ReplicatedInteger.valueOf(i)));
            }
            int truncateIndex = tlr.nextInt(finalAppendIndex);
            while (truncateIndex-- > 0) {
                this.raftLog.truncate(truncateIndex);
            }
            ++i;
        }
    }

    @Test
    public void shouldBeAbleToAppendAfterSkip() throws Throwable {
        int term = 0;
        this.raftLog.append(new RaftLogEntry((long)term, (ReplicatedContent)ReplicatedInteger.valueOf(10)));
        int newTerm = 3;
        this.raftLog.skip(5L, newTerm);
        RaftLogEntry newEntry = new RaftLogEntry((long)newTerm, (ReplicatedContent)ReplicatedInteger.valueOf(20));
        this.raftLog.append(newEntry);
        Assert.assertEquals((Object)newEntry, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)this.raftLog, 6L));
    }
}

