/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import org.junit.Assert;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;

class VerifyingRaftLog
implements RaftLog {
    private InMemoryRaftLog expected = new InMemoryRaftLog();
    private final RaftLog other;

    VerifyingRaftLog(RaftLog other) {
        this.other = other;
    }

    public long append(RaftLogEntry ... entries) throws IOException {
        long appendIndex = this.expected.append(entries);
        Assert.assertEquals((long)appendIndex, (long)this.other.append(entries));
        return appendIndex;
    }

    public void truncate(long fromIndex) throws IOException {
        this.expected.truncate(fromIndex);
        this.other.truncate(fromIndex);
    }

    public long prune(long safeIndex) throws IOException {
        long pruneIndex = this.other.prune(safeIndex);
        Assert.assertEquals((long)pruneIndex, (long)this.expected.prune(pruneIndex));
        return pruneIndex;
    }

    public long appendIndex() {
        long appendIndex = this.expected.appendIndex();
        Assert.assertEquals((long)appendIndex, (long)this.other.appendIndex());
        return appendIndex;
    }

    public long prevIndex() {
        long prevIndex = this.expected.appendIndex();
        Assert.assertEquals((long)prevIndex, (long)this.other.appendIndex());
        return prevIndex;
    }

    public long readEntryTerm(long logIndex) throws IOException {
        long term = this.expected.readEntryTerm(logIndex);
        Assert.assertEquals((long)term, (long)this.other.readEntryTerm(logIndex));
        return term;
    }

    public RaftLogCursor getEntryCursor(long fromIndex) throws IOException {
        return this.other.getEntryCursor(fromIndex);
    }

    public long skip(long index, long term) throws IOException {
        long expectedAppendIndex = this.expected.skip(index, term);
        Assert.assertEquals((long)expectedAppendIndex, (long)this.other.skip(index, term));
        return expectedAppendIndex;
    }

    public void verify() throws IOException {
        this.verifyUsing(this.other);
    }

    public void verifyUsing(RaftLog other) throws IOException {
        Assert.assertEquals((long)this.expected.appendIndex(), (long)other.appendIndex());
        this.verifyTraversalUsingCursor((RaftLog)this.expected, other);
        this.verifyDirectLookupForwards(this.expected, other);
        this.verifyDirectLookupBackwards(this.expected, other);
    }

    private void verifyDirectLookupForwards(InMemoryRaftLog expected, RaftLog other) throws IOException {
        for (long logIndex = expected.prevIndex() + 1L; logIndex <= expected.appendIndex(); ++logIndex) {
            this.directAssertions(expected, other, logIndex);
        }
    }

    private void verifyDirectLookupBackwards(InMemoryRaftLog expected, RaftLog other) throws IOException {
        for (long logIndex = expected.appendIndex(); logIndex > expected.prevIndex(); --logIndex) {
            this.directAssertions(expected, other, logIndex);
        }
    }

    private void directAssertions(InMemoryRaftLog expected, RaftLog other, long logIndex) throws IOException {
        Assert.assertEquals((long)expected.readEntryTerm(logIndex), (long)other.readEntryTerm(logIndex));
    }

    private void verifyTraversalUsingCursor(RaftLog expected, RaftLog other) throws IOException {
        long startIndex = expected.prevIndex() + 1L;
        try (RaftLogCursor expectedCursor = expected.getEntryCursor(startIndex);
             RaftLogCursor otherCursor = other.getEntryCursor(startIndex);){
            boolean expectedNext;
            do {
                expectedNext = expectedCursor.next();
                Assert.assertEquals((Object)expectedNext, (Object)otherCursor.next());
                if (!expectedNext) continue;
                Assert.assertEquals((Object)expectedCursor.get(), (Object)otherCursor.get());
                Assert.assertEquals((long)expectedCursor.index(), (long)otherCursor.index());
            } while (expectedNext);
        }
    }
}

