/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.time.Clock;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.log.segmented.EntryCursor;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.Segments;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class EntryCursorTest {
    private final FileSystemAbstraction fsa = new EphemeralFileSystemAbstraction();
    private final File bam = new File("bam");
    private final FileNames fileNames = new FileNames(this.bam);
    private ReaderPool readerPool = new ReaderPool(0, (LogProvider)NullLogProvider.getInstance(), this.fileNames, this.fsa, (Clock)Clocks.fakeClock());
    private final Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, Collections.emptyList(), (ChannelMarshal)Mockito.mock(ChannelMarshal.class), (LogProvider)NullLogProvider.getInstance(), -1L);

    public EntryCursorTest() {
        this.fsa.mkdir(this.bam);
    }

    @After
    public void tearDown() throws Exception {
        this.fsa.close();
    }

    @Test
    public void ifFileExistsButEntryDoesNotExist() throws Exception {
        this.segments.rotate(-1L, -1L, -1L);
        this.segments.rotate(10L, 10L, 10L);
        this.segments.last().closeWriter();
        EntryCursor entryCursor = new EntryCursor(this.segments, 1L);
        boolean next = entryCursor.next();
        Assert.assertFalse((boolean)next);
    }

    @Test
    public void requestedSegmentHasBeenPruned() throws Exception {
        this.segments.rotate(-1L, -1L, -1L);
        this.segments.rotate(10L, 10L, 10L);
        this.segments.rotate(20L, 20L, 20L);
        this.segments.prune(12L);
        this.segments.last().closeWriter();
        EntryCursor entryCursor = new EntryCursor(this.segments, 1L);
        boolean next = entryCursor.next();
        Assert.assertFalse((boolean)next);
    }

    @Test
    public void requestedSegmentHasNotExistedYet() throws Exception {
        this.segments.rotate(-1L, -1L, -1L);
        this.segments.rotate(10L, 10L, 10L);
        this.segments.rotate(20L, 20L, 20L);
        this.segments.last().closeWriter();
        EntryCursor entryCursor = new EntryCursor(this.segments, 100L);
        boolean next = entryCursor.next();
        Assert.assertFalse((boolean)next);
    }
}

