/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.OpenEndRangeMap;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.consensus.log.segmented.Segments;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class SegmentsTest {
    private final FileSystemAbstraction fsa = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class, (Answer)Mockito.RETURNS_MOCKS);
    private final File baseDirectory = new File(".");
    private final FileNames fileNames = new FileNames(this.baseDirectory);
    private final ChannelMarshal<ReplicatedContent> contentMarshal = (ChannelMarshal)Mockito.mock(ChannelMarshal.class);
    private final LogProvider logProvider = NullLogProvider.getInstance();
    private final SegmentHeader header = (SegmentHeader)Mockito.mock(SegmentHeader.class);
    private final ReaderPool readerPool = new ReaderPool(0, (LogProvider)NullLogProvider.getInstance(), this.fileNames, this.fsa, (Clock)Clocks.fakeClock());
    private final SegmentFile fileA = (SegmentFile)Mockito.spy((Object)new SegmentFile(this.fsa, this.fileNames.getForVersion(0L), this.readerPool, 0L, this.contentMarshal, this.logProvider, this.header));
    private final SegmentFile fileB = (SegmentFile)Mockito.spy((Object)new SegmentFile(this.fsa, this.fileNames.getForVersion(1L), this.readerPool, 1L, this.contentMarshal, this.logProvider, this.header));
    private final List<SegmentFile> segmentFiles = Arrays.asList(this.fileA, this.fileB);

    @Before
    public void before() {
        Mockito.when((Object)this.fsa.deleteFile((File)ArgumentMatchers.any())).thenReturn((Object)true);
    }

    @Test
    public void shouldCreateNext() throws Exception {
        try (Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);){
            segments.rotate(10L, 10L, 12L);
            segments.last().closeWriter();
            SegmentFile last = segments.last();
            Assert.assertEquals((long)10L, (long)last.header().prevFileLastIndex());
            Assert.assertEquals((long)10L, (long)last.header().prevIndex());
            Assert.assertEquals((long)12L, (long)last.header().prevTerm());
        }
    }

    @Test
    public void shouldDeleteOnPrune() throws Exception {
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.fsa});
        try (Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);){
            SegmentFile toPrune = segments.rotate(-1L, -1L, -1L);
            segments.last().closeWriter();
            segments.rotate(10L, 10L, 2L);
            segments.last().closeWriter();
            segments.rotate(20L, 20L, 2L);
            segments.prune(11L);
            ((FileSystemAbstraction)Mockito.verify((Object)this.fsa, (VerificationMode)Mockito.times((int)this.segmentFiles.size()))).deleteFile(this.fileNames.getForVersion(toPrune.header().version()));
        }
    }

    @Test
    public void shouldNeverDeleteOnTruncate() throws Exception {
        try (Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);){
            segments.rotate(-1L, -1L, -1L);
            segments.last().closeWriter();
            segments.rotate(10L, 10L, 2L);
            segments.last().closeWriter();
            segments.truncate(20L, 9L, 4L);
            ((FileSystemAbstraction)Mockito.verify((Object)this.fsa, (VerificationMode)Mockito.never())).deleteFile((File)ArgumentMatchers.any());
        }
    }

    @Test
    public void shouldDeleteTruncatedFilesOnPrune() throws Exception {
        try (Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);){
            SegmentFile toBePruned = segments.rotate(-1L, -1L, -1L);
            segments.last().closeWriter();
            SegmentFile toBeTruncated = segments.rotate(10L, 10L, 2L);
            segments.last().closeWriter();
            segments.truncate(20L, 9L, 4L);
            segments.prune(10L);
            ((FileSystemAbstraction)Mockito.verify((Object)this.fsa, (VerificationMode)Mockito.times((int)this.segmentFiles.size()))).deleteFile(this.fileNames.getForVersion(toBePruned.header().version()));
        }
    }

    @Test
    public void shouldCloseTheSegments() {
        Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);
        segments.close();
        for (SegmentFile file : this.segmentFiles) {
            ((SegmentFile)Mockito.verify((Object)file)).close();
        }
    }

    @Test
    public void shouldNotSwallowExceptionOnClose() {
        ((SegmentFile)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.fileA)).close();
        ((SegmentFile)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.fileB)).close();
        Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);
        try {
            segments.close();
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException ex) {
            Throwable[] suppressed = ex.getSuppressed();
            Assert.assertEquals((long)1L, (long)suppressed.length);
            Assert.assertTrue((boolean)(suppressed[0] instanceof RuntimeException));
        }
    }

    @Test
    public void shouldAllowOutOfBoundsPruneIndex() throws Exception {
        Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, this.segmentFiles, this.contentMarshal, this.logProvider, -1L);
        segments.rotate(-1L, -1L, -1L);
        segments.last().closeWriter();
        segments.rotate(10L, 10L, 2L);
        segments.last().closeWriter();
        segments.prune(11L);
        segments.rotate(20L, 20L, 3L);
        segments.last().closeWriter();
        SegmentFile oldestNotDisposed = segments.prune(-1L);
        SegmentHeader header = oldestNotDisposed.header();
        Assert.assertEquals((long)10L, (long)header.prevFileLastIndex());
        Assert.assertEquals((long)10L, (long)header.prevIndex());
        Assert.assertEquals((long)2L, (long)header.prevTerm());
    }

    @Test
    public void attemptsPruningUntilOpenFileIsFound() throws Exception {
        Segments segments = new Segments(this.fsa, this.fileNames, this.readerPool, Collections.emptyList(), this.contentMarshal, this.logProvider, -1L);
        segments.rotate(-1L, -1L, -1L);
        segments.last().closeWriter();
        segments.rotate(10L, 10L, 2L);
        segments.last().closeWriter();
        IOCursor reader = segments.last().getCursor(11L);
        segments.rotate(20L, 20L, 3L);
        segments.last().closeWriter();
        segments.rotate(30L, 30L, 4L);
        segments.last().closeWriter();
        segments.prune(31L);
        OpenEndRangeMap.ValueRange shouldBePruned = segments.getForIndex(5L);
        OpenEndRangeMap.ValueRange shouldNotBePruned = segments.getForIndex(15L);
        OpenEndRangeMap.ValueRange shouldAlsoNotBePruned = segments.getForIndex(25L);
        Assert.assertFalse((boolean)shouldBePruned.value().isPresent());
        Assert.assertTrue((boolean)shouldNotBePruned.value().isPresent());
        Assert.assertTrue((boolean)shouldAlsoNotBePruned.value().isPresent());
        reader.close();
        segments.prune(31L);
        shouldBePruned = segments.getForIndex(5L);
        shouldNotBePruned = segments.getForIndex(15L);
        shouldAlsoNotBePruned = segments.getForIndex(25L);
        Assert.assertFalse((boolean)shouldBePruned.value().isPresent());
        Assert.assertFalse((boolean)shouldNotBePruned.value().isPresent());
        Assert.assertFalse((boolean)shouldAlsoNotBePruned.value().isPresent());
    }
}

