/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.util.LinkedList;
import java.util.List;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.identity.MemberId;

public class AppendEntriesRequestBuilder {
    private List<RaftLogEntry> logEntries = new LinkedList<RaftLogEntry>();
    private long leaderCommit = -1L;
    private long prevLogTerm = -1L;
    private long prevLogIndex = -1L;
    private long leaderTerm = -1L;
    private MemberId from;

    public RaftMessages.AppendEntries.Request build() {
        return new RaftMessages.AppendEntries.Request(this.from, this.leaderTerm, this.prevLogIndex, this.prevLogTerm, this.logEntries.toArray(new RaftLogEntry[this.logEntries.size()]), this.leaderCommit);
    }

    public AppendEntriesRequestBuilder from(MemberId from) {
        this.from = from;
        return this;
    }

    public AppendEntriesRequestBuilder leaderTerm(long leaderTerm) {
        this.leaderTerm = leaderTerm;
        return this;
    }

    public AppendEntriesRequestBuilder prevLogIndex(long prevLogIndex) {
        this.prevLogIndex = prevLogIndex;
        return this;
    }

    public AppendEntriesRequestBuilder prevLogTerm(long prevLogTerm) {
        this.prevLogTerm = prevLogTerm;
        return this;
    }

    public AppendEntriesRequestBuilder logEntry(RaftLogEntry logEntry) {
        this.logEntries.add(logEntry);
        return this;
    }

    public AppendEntriesRequestBuilder leaderCommit(long leaderCommit) {
        this.leaderCommit = leaderCommit;
        return this;
    }
}

