/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.AppendEntriesRequestTest;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class HeartbeatTest {
    @Parameterized.Parameter(value=0)
    public Role role;
    @Parameterized.Parameter(value=1)
    public int leaderTermDifference;
    private MemberId myself = RaftTestMember.member(0);
    private MemberId leader = RaftTestMember.member(1);

    @Parameterized.Parameters(name="{0} with leader {1} terms ahead.")
    public static Collection<Object[]> data() {
        return Arrays.asList({Role.FOLLOWER, 0}, {Role.FOLLOWER, 1}, {Role.LEADER, 1}, {Role.CANDIDATE, 1});
    }

    @Test
    public void shouldNotResultInCommitIfReferringToFutureEntries() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)raftLog).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(leaderTerm, (ReplicatedContent)AppendEntriesRequestTest.ContentGenerator.content())});
        RaftMessages.Heartbeat heartbeat = TestMessageBuilders.heartbeat().from(this.leader).commitIndex(raftLog.appendIndex() + 1L).commitIndexTerm(leaderTerm).leaderTerm(leaderTerm).build();
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)heartbeat, (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotResultInCommitIfHistoryMismatches() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)raftLog).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(leaderTerm, (ReplicatedContent)AppendEntriesRequestTest.ContentGenerator.content())});
        RaftMessages.Heartbeat heartbeat = TestMessageBuilders.heartbeat().from(this.leader).commitIndex(raftLog.appendIndex()).commitIndexTerm(leaderTerm).leaderTerm(leaderTerm).build();
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)heartbeat, (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getCommitIndex(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void shouldResultInCommitIfHistoryMatches() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)raftLog).build();
        long leaderTerm = state.term() + (long)this.leaderTermDifference;
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(leaderTerm - 1L, (ReplicatedContent)AppendEntriesRequestTest.ContentGenerator.content())});
        RaftMessages.Heartbeat heartbeat = TestMessageBuilders.heartbeat().from(this.leader).commitIndex(raftLog.appendIndex()).commitIndexTerm(leaderTerm).leaderTerm(leaderTerm).build();
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)heartbeat, (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)Matchers.empty());
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }
}

