/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.vote;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.identity.MemberId;

public class VoteStateTest {
    @Test
    public void shouldStoreVote() {
        VoteState voteState = new VoteState();
        MemberId member = new MemberId(UUID.randomUUID());
        voteState.update(member, 0L);
        Assert.assertEquals((Object)member, (Object)voteState.votedFor());
    }

    @Test
    public void shouldStartWithNoVote() {
        VoteState voteState = new VoteState();
        Assert.assertNull((Object)voteState.votedFor());
    }

    @Test
    public void shouldUpdateVote() {
        VoteState voteState = new VoteState();
        MemberId member1 = new MemberId(UUID.randomUUID());
        MemberId member2 = new MemberId(UUID.randomUUID());
        voteState.update(member1, 0L);
        voteState.update(member2, 1L);
        Assert.assertEquals((Object)member2, (Object)voteState.votedFor());
    }

    @Test
    public void shouldClearVote() {
        VoteState voteState = new VoteState();
        MemberId member = new MemberId(UUID.randomUUID());
        voteState.update(member, 0L);
        voteState.update(null, 1L);
        Assert.assertNull((Object)voteState.votedFor());
    }

    @Test
    public void shouldNotUpdateVoteForSameTerm() {
        VoteState voteState = new VoteState();
        MemberId member1 = new MemberId(UUID.randomUUID());
        MemberId member2 = new MemberId(UUID.randomUUID());
        voteState.update(member1, 0L);
        try {
            voteState.update(member2, 0L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotClearVoteForSameTerm() {
        VoteState voteState = new VoteState();
        MemberId member = new MemberId(UUID.randomUUID());
        voteState.update(member, 0L);
        try {
            voteState.update(null, 0L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReportNoUpdateWhenVoteStateUnchanged() {
        VoteState voteState = new VoteState();
        MemberId member1 = new MemberId(UUID.randomUUID());
        MemberId member2 = new MemberId(UUID.randomUUID());
        Assert.assertTrue((boolean)voteState.update(null, 0L));
        Assert.assertFalse((boolean)voteState.update(null, 0L));
        Assert.assertTrue((boolean)voteState.update(member1, 0L));
        Assert.assertFalse((boolean)voteState.update(member1, 0L));
        Assert.assertTrue((boolean)voteState.update(member2, 1L));
        Assert.assertFalse((boolean)voteState.update(member2, 1L));
    }
}

