/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.state.ExposedRaftState;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.core.state.machines.id.IdReusabilityCondition;
import org.neo4j.causalclustering.identity.MemberId;

public class IdReusabilityConditionTest {
    private RaftMachine raftMachine = (RaftMachine)Mockito.mock(RaftMachine.class);
    private ExposedRaftState state = (ExposedRaftState)Mockito.mock(ExposedRaftState.class);
    private MemberId myself;
    private CommandIndexTracker commandIndexTracker = (CommandIndexTracker)Mockito.mock(CommandIndexTracker.class);
    private IdReusabilityCondition idReusabilityCondition;

    @Before
    public void setUp() {
        Mockito.when((Object)this.raftMachine.state()).thenReturn((Object)this.state);
        this.myself = new MemberId(UUID.randomUUID());
        this.idReusabilityCondition = new IdReusabilityCondition(this.commandIndexTracker, this.raftMachine, this.myself);
    }

    @Test
    public void shouldReturnFalseAsDefault() {
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
    }

    @Test
    public void shouldNeverReuseWhenNotLeader() {
        MemberId someoneElse = new MemberId(UUID.randomUUID());
        this.idReusabilityCondition.onLeaderSwitch(new LeaderInfo(someoneElse, 1L));
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
    }

    @Test
    public void shouldNotReturnTrueWithPendingTransactions() {
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Mockito.when((Object)this.commandIndexTracker.getAppliedCommandIndex()).thenReturn((Object)2L);
        Mockito.when((Object)this.state.lastLogIndexBeforeWeBecameLeader()).thenReturn((Object)5L);
        this.idReusabilityCondition.onLeaderSwitch(new LeaderInfo(this.myself, 1L));
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        ((CommandIndexTracker)Mockito.verify((Object)this.commandIndexTracker, (VerificationMode)Mockito.times((int)3))).getAppliedCommandIndex();
        ((ExposedRaftState)Mockito.verify((Object)this.state)).lastLogIndexBeforeWeBecameLeader();
    }

    @Test
    public void shouldOnlyReturnTrueWhenOldTransactionsBeenApplied() {
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Mockito.when((Object)this.commandIndexTracker.getAppliedCommandIndex()).thenReturn((Object)2L, (Object[])new Long[]{5L, 6L});
        Mockito.when((Object)this.state.lastLogIndexBeforeWeBecameLeader()).thenReturn((Object)5L);
        this.idReusabilityCondition.onLeaderSwitch(new LeaderInfo(this.myself, 1L));
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Assert.assertTrue((boolean)this.idReusabilityCondition.getAsBoolean());
        ((CommandIndexTracker)Mockito.verify((Object)this.commandIndexTracker, (VerificationMode)Mockito.times((int)3))).getAppliedCommandIndex();
        ((ExposedRaftState)Mockito.verify((Object)this.state)).lastLogIndexBeforeWeBecameLeader();
    }

    @Test
    public void shouldNotReuseIfReelection() {
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Mockito.when((Object)this.commandIndexTracker.getAppliedCommandIndex()).thenReturn((Object)2L, (Object[])new Long[]{5L, 6L});
        Mockito.when((Object)this.state.lastLogIndexBeforeWeBecameLeader()).thenReturn((Object)5L);
        this.idReusabilityCondition.onLeaderSwitch(new LeaderInfo(this.myself, 1L));
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
        Assert.assertTrue((boolean)this.idReusabilityCondition.getAsBoolean());
        MemberId someoneElse = new MemberId(UUID.randomUUID());
        this.idReusabilityCondition.onLeaderSwitch(new LeaderInfo(someoneElse, 1L));
        Assert.assertFalse((boolean)this.idReusabilityCondition.getAsBoolean());
    }
}

