/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.CommitStateHelper;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CoreStateDownloaderTest {
    private final LocalDatabase localDatabase = (LocalDatabase)Mockito.mock(LocalDatabase.class);
    private final Suspendable startStopLife = (Suspendable)Mockito.mock(Suspendable.class);
    private final RemoteStore remoteStore = (RemoteStore)Mockito.mock(RemoteStore.class);
    private final CatchUpClient catchUpClient = (CatchUpClient)Mockito.mock(CatchUpClient.class);
    private final StoreCopyProcess storeCopyProcess = (StoreCopyProcess)Mockito.mock(StoreCopyProcess.class);
    private CoreSnapshotService snapshotService = (CoreSnapshotService)Mockito.mock(CoreSnapshotService.class);
    private TopologyService topologyService = (TopologyService)Mockito.mock(TopologyService.class);
    private CommitStateHelper commitStateHelper = (CommitStateHelper)Mockito.mock(CommitStateHelper.class);
    private final CoreStateMachines coreStateMachines = (CoreStateMachines)Mockito.mock(CoreStateMachines.class);
    private final NullLogProvider logProvider = NullLogProvider.getInstance();
    private final MemberId remoteMember = new MemberId(UUID.randomUUID());
    private final AdvertisedSocketAddress remoteAddress = new AdvertisedSocketAddress("remoteAddress", 1234);
    private final CatchupAddressProvider catchupAddressProvider = CatchupAddressProvider.fromSingleAddress((AdvertisedSocketAddress)this.remoteAddress);
    private final StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
    private final File storeDir = new File("graph.db");
    private final CoreStateDownloader downloader = new CoreStateDownloader(this.localDatabase, this.startStopLife, this.remoteStore, this.catchUpClient, (LogProvider)this.logProvider, this.storeCopyProcess, this.coreStateMachines, this.snapshotService, this.commitStateHelper);

    @Before
    public void commonMocking() {
        Mockito.when((Object)this.localDatabase.storeId()).thenReturn((Object)this.storeId);
        Mockito.when((Object)this.localDatabase.storeDir()).thenReturn((Object)this.storeDir);
        Mockito.when((Object)this.topologyService.findCatchupAddress(this.remoteMember)).thenReturn(Optional.of(this.remoteAddress));
    }

    @Test
    public void shouldDownloadCompleteStoreWhenEmpty() throws Throwable {
        StoreId remoteStoreId = new StoreId(5L, 6L, 7L, 8L);
        Mockito.when((Object)this.remoteStore.getStoreId(this.remoteAddress)).thenReturn((Object)remoteStoreId);
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)true);
        this.downloader.downloadSnapshot(this.catchupAddressProvider);
        ((RemoteStore)Mockito.verify((Object)this.remoteStore, (VerificationMode)Mockito.never())).tryCatchingUp((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        ((StoreCopyProcess)Mockito.verify((Object)this.storeCopyProcess)).replaceWithStoreFrom(this.catchupAddressProvider, remoteStoreId);
    }

    @Test
    public void shouldStopDatabaseDuringDownload() throws Throwable {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)true);
        this.downloader.downloadSnapshot(this.catchupAddressProvider);
        ((Suspendable)Mockito.verify((Object)this.startStopLife)).disable();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).stopForStoreCopy();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Suspendable)Mockito.verify((Object)this.startStopLife)).enable();
    }

    @Test
    public void shouldNotOverwriteNonEmptyMismatchingStore() throws Exception {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        StoreId remoteStoreId = new StoreId(5L, 6L, 7L, 8L);
        Mockito.when((Object)this.remoteStore.getStoreId(this.remoteAddress)).thenReturn((Object)remoteStoreId);
        Assert.assertFalse((boolean)this.downloader.downloadSnapshot(this.catchupAddressProvider));
        ((RemoteStore)Mockito.verify((Object)this.remoteStore, (VerificationMode)Mockito.never())).copy((CatchupAddressProvider)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), (File)ArgumentMatchers.any());
        ((RemoteStore)Mockito.verify((Object)this.remoteStore, (VerificationMode)Mockito.never())).tryCatchingUp((AdvertisedSocketAddress)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldCatchupIfPossible() throws Exception {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.remoteStore.getStoreId(this.remoteAddress)).thenReturn((Object)this.storeId);
        Mockito.when((Object)this.remoteStore.tryCatchingUp(this.remoteAddress, this.storeId, this.storeDir, false)).thenReturn((Object)CatchupResult.SUCCESS_END_OF_STREAM);
        this.downloader.downloadSnapshot(this.catchupAddressProvider);
        ((RemoteStore)Mockito.verify((Object)this.remoteStore)).tryCatchingUp(this.remoteAddress, this.storeId, this.storeDir, false);
        ((RemoteStore)Mockito.verify((Object)this.remoteStore, (VerificationMode)Mockito.never())).copy((CatchupAddressProvider)ArgumentMatchers.any(), (StoreId)ArgumentMatchers.any(), (File)ArgumentMatchers.any());
    }

    @Test
    public void shouldDownloadWholeStoreIfCannotCatchUp() throws Exception {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.remoteStore.getStoreId(this.remoteAddress)).thenReturn((Object)this.storeId);
        Mockito.when((Object)this.remoteStore.tryCatchingUp(this.remoteAddress, this.storeId, this.storeDir, false)).thenReturn((Object)CatchupResult.E_TRANSACTION_PRUNED);
        this.downloader.downloadSnapshot(this.catchupAddressProvider);
        ((RemoteStore)Mockito.verify((Object)this.remoteStore)).tryCatchingUp(this.remoteAddress, this.storeId, this.storeDir, false);
        ((StoreCopyProcess)Mockito.verify((Object)this.storeCopyProcess)).replaceWithStoreFrom(this.catchupAddressProvider, this.storeId);
    }
}

