/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.NoTimeout;
import org.neo4j.causalclustering.core.state.snapshot.PersistentSnapshotDownloader;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class PersistentSnapshotDownloaderTest {
    private final AdvertisedSocketAddress fromAddress = new AdvertisedSocketAddress("localhost", 1234);
    private final CatchupAddressProvider catchupAddressProvider = CatchupAddressProvider.fromSingleAddress((AdvertisedSocketAddress)this.fromAddress);
    private final DatabaseHealth dbHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);

    @Test
    public void shouldPauseAndResumeApplicationProcessIfDownloadIsSuccessful() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        Mockito.when((Object)coreStateDownloader.downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any())).thenReturn((Object)true);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(this.catchupAddressProvider, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)new NoTimeout(), () -> this.dbHealth);
        persistentSnapshotDownloader.run();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        ((CoreStateDownloader)Mockito.verify((Object)coreStateDownloader, (VerificationMode)VerificationModeFactory.times((int)1))).downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any());
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldResumeCommandApplicationProcessIfInterrupted() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        Mockito.when((Object)coreStateDownloader.downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any())).thenReturn((Object)false);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(this.catchupAddressProvider, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout, () -> this.dbHealth);
        Thread thread = new Thread((Runnable)persistentSnapshotDownloader);
        thread.start();
        this.awaitOneIteration(timeout);
        thread.interrupt();
        thread.join();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldResumeCommandApplicationProcessIfDownloaderIsStopped() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        Mockito.when((Object)coreStateDownloader.downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any())).thenReturn((Object)false);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(null, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout, () -> this.dbHealth);
        Thread thread = new Thread((Runnable)persistentSnapshotDownloader);
        thread.start();
        this.awaitOneIteration(timeout);
        persistentSnapshotDownloader.stop();
        thread.join();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldEventuallySucceed() {
        EventuallySuccessfulDownloader coreStateDownloader = new EventuallySuccessfulDownloader(3);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(this.catchupAddressProvider, applicationProcess, (CoreStateDownloader)coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout, () -> this.dbHealth);
        persistentSnapshotDownloader.run();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
        Assert.assertEquals((long)3L, (long)timeout.currentCount());
        Assert.assertTrue((boolean)persistentSnapshotDownloader.hasCompleted());
    }

    @Test
    public void shouldNotStartDownloadIfAlreadyCompleted() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        Mockito.when((Object)coreStateDownloader.downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any())).thenReturn((Object)true);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Log log = (Log)Mockito.mock(Log.class);
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(this.catchupAddressProvider, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)new NoTimeout(), () -> this.dbHealth);
        persistentSnapshotDownloader.run();
        persistentSnapshotDownloader.run();
        ((CoreStateDownloader)Mockito.verify((Object)coreStateDownloader, (VerificationMode)VerificationModeFactory.times((int)1))).downloadSnapshot(this.catchupAddressProvider);
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
    }

    @Test
    public void shouldNotStartIfCurrentlyRunning() throws Exception {
        CoreStateDownloader coreStateDownloader = (CoreStateDownloader)Mockito.mock(CoreStateDownloader.class);
        CommandApplicationProcess applicationProcess = (CommandApplicationProcess)Mockito.mock(CommandApplicationProcess.class);
        Mockito.when((Object)coreStateDownloader.downloadSnapshot((CatchupAddressProvider)ArgumentMatchers.any())).thenReturn((Object)false);
        Log log = (Log)Mockito.mock(Log.class);
        NoTimeout timeout = new NoTimeout();
        PersistentSnapshotDownloader persistentSnapshotDownloader = new PersistentSnapshotDownloader(this.catchupAddressProvider, applicationProcess, coreStateDownloader, log, (TimeoutStrategy.Timeout)timeout, () -> this.dbHealth);
        Thread thread = new Thread((Runnable)persistentSnapshotDownloader);
        thread.start();
        this.awaitOneIteration(timeout);
        persistentSnapshotDownloader.run();
        persistentSnapshotDownloader.stop();
        thread.join();
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).pauseApplier("download of snapshot");
        ((CommandApplicationProcess)Mockito.verify((Object)applicationProcess, (VerificationMode)VerificationModeFactory.times((int)1))).resumeApplier("download of snapshot");
    }

    private void awaitOneIteration(NoTimeout timeout) throws TimeoutException {
        Predicates.await(() -> timeout.currentCount() > 0, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    private class EventuallySuccessfulDownloader
    extends CoreStateDownloader {
        private int after;

        private EventuallySuccessfulDownloader(int after) {
            super(null, null, null, null, (LogProvider)NullLogProvider.getInstance(), null, null, null, null);
            this.after = after;
        }

        boolean downloadSnapshot(CatchupAddressProvider addressProvider) {
            return this.after-- <= 0;
        }
    }
}

