/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.RaftLogPruner;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Level;

public class CoreClusterMember
implements ClusterMember<CoreGraphDatabase> {
    private final File neo4jHome;
    protected final DiscoveryServiceFactory discoveryServiceFactory;
    protected final File storeDir;
    private final File clusterStateDir;
    private final File raftLogDir;
    private final Map<String, String> config = MapUtil.stringMap((String[])new String[0]);
    private final int serverId;
    private final String boltAdvertisedSocketAddress;
    private final int discoveryPort;
    private final String raftListenAddress;
    protected CoreGraphDatabase database;
    private final Config memberConfig;
    private final ThreadGroup threadGroup;
    private final Monitors monitors = new Monitors();
    private final String dbName;

    public CoreClusterMember(int serverId, int discoveryPort, int txPort, int raftPort, int boltPort, int httpPort, int backupPort, int clusterSize, List<AdvertisedSocketAddress> addresses, DiscoveryServiceFactory discoveryServiceFactory, String recordFormat, File parentDir, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams, String listenAddress, String advertisedAddress) {
        this.serverId = serverId;
        this.discoveryPort = discoveryPort;
        String initialMembers = addresses.stream().map(SocketAddress::toString).collect(Collectors.joining(","));
        this.boltAdvertisedSocketAddress = AdvertisedSocketAddress.advertisedAddress((String)advertisedAddress, (int)boltPort);
        this.raftListenAddress = ListenSocketAddress.listenAddress((String)listenAddress, (int)raftPort);
        this.config.put(EnterpriseEditionSettings.mode.name(), EnterpriseEditionSettings.Mode.CORE.name());
        this.config.put(GraphDatabaseSettings.default_advertised_address.name(), advertisedAddress);
        this.config.put(CausalClusteringSettings.initial_discovery_members.name(), initialMembers);
        this.config.put(CausalClusteringSettings.discovery_listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)discoveryPort));
        this.config.put(CausalClusteringSettings.transaction_listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)txPort));
        this.config.put(CausalClusteringSettings.raft_listen_address.name(), this.raftListenAddress);
        this.config.put(CausalClusteringSettings.cluster_topology_refresh.name(), "1000ms");
        this.config.put(CausalClusteringSettings.minimum_core_cluster_size_at_formation.name(), String.valueOf(clusterSize));
        this.config.put(CausalClusteringSettings.minimum_core_cluster_size_at_runtime.name(), String.valueOf(clusterSize));
        this.config.put(CausalClusteringSettings.leader_election_timeout.name(), "500ms");
        this.config.put(CausalClusteringSettings.raft_messages_log_enable.name(), "true");
        this.config.put(GraphDatabaseSettings.store_internal_log_level.name(), Level.DEBUG.name());
        this.config.put(GraphDatabaseSettings.record_format.name(), recordFormat);
        this.config.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        this.config.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        this.config.put(new BoltConnector((String)"bolt").listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)boltPort));
        this.config.put(new BoltConnector((String)"bolt").advertised_address.name(), this.boltAdvertisedSocketAddress);
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).type.name(), "HTTP");
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).enabled.name(), "true");
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).listen_address.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)httpPort));
        this.config.put(new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).advertised_address.name(), AdvertisedSocketAddress.advertisedAddress((String)advertisedAddress, (int)httpPort));
        this.config.put(OnlineBackupSettings.online_backup_server.name(), ListenSocketAddress.listenAddress((String)listenAddress, (int)backupPort));
        this.config.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        this.config.put(GraphDatabaseSettings.auth_store.name(), new File(parentDir, "auth").getAbsolutePath());
        this.config.putAll(extraParams);
        for (Map.Entry<String, IntFunction<String>> entry : instanceExtraParams.entrySet()) {
            this.config.put(entry.getKey(), entry.getValue().apply(serverId));
        }
        this.neo4jHome = new File(parentDir, "server-core-" + serverId);
        this.config.put(GraphDatabaseSettings.neo4j_home.name(), this.neo4jHome.getAbsolutePath());
        this.config.put(GraphDatabaseSettings.logs_directory.name(), new File(this.neo4jHome, "logs").getAbsolutePath());
        this.config.put(GraphDatabaseSettings.logical_logs_location.name(), "core-tx-logs-" + serverId);
        this.discoveryServiceFactory = discoveryServiceFactory;
        File dataDir = new File(this.neo4jHome, "data");
        this.clusterStateDir = ClusterStateDirectory.withoutInitializing((File)dataDir).get();
        this.raftLogDir = new File(this.clusterStateDir, "raft-log");
        this.storeDir = new File(new File(dataDir, "databases"), "graph.db");
        this.memberConfig = Config.defaults(this.config);
        this.dbName = (String)this.memberConfig.get(CausalClusteringSettings.database);
        this.storeDir.mkdirs();
        this.threadGroup = new ThreadGroup(this.toString());
    }

    public String boltAdvertisedAddress() {
        return this.boltAdvertisedSocketAddress;
    }

    public String routingURI() {
        return String.format("bolt+routing://%s", this.boltAdvertisedSocketAddress);
    }

    public String directURI() {
        return String.format("bolt://%s", this.boltAdvertisedSocketAddress);
    }

    public String raftListenAddress() {
        return this.raftListenAddress;
    }

    @Override
    public void start() {
        this.database = new CoreGraphDatabase(this.storeDir, this.memberConfig, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().monitors(this.monitors), this.discoveryServiceFactory);
    }

    @Override
    public void shutdown() {
        if (this.database != null) {
            try {
                this.database.shutdown();
            }
            finally {
                this.database = null;
            }
        }
    }

    @Override
    public boolean isShutdown() {
        return this.database == null;
    }

    @Override
    public CoreGraphDatabase database() {
        return this.database;
    }

    @Override
    public File storeDir() {
        return this.storeDir;
    }

    public RaftLogPruner raftLogPruner() {
        return (RaftLogPruner)this.database.getDependencyResolver().resolveDependency(RaftLogPruner.class);
    }

    public RaftMachine raft() {
        return (RaftMachine)this.database.getDependencyResolver().resolveDependency(RaftMachine.class);
    }

    public MemberId id() {
        return ((RaftMachine)this.database.getDependencyResolver().resolveDependency(RaftMachine.class)).identity();
    }

    public SortedMap<Long, File> getLogFileNames() throws IOException {
        File logFilesDir = new File(this.clusterStateDir, "raft-log");
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            SortedMap sortedMap = new FileNames(logFilesDir).getAllFiles((FileSystemAbstraction)fileSystem, null);
            return sortedMap;
        }
    }

    @Override
    public File homeDir() {
        return this.neo4jHome;
    }

    public String toString() {
        return String.format("CoreClusterMember{serverId=%d}", this.serverId);
    }

    @Override
    public int serverId() {
        return this.serverId;
    }

    public String dbName() {
        return this.dbName;
    }

    @Override
    public ClientConnectorAddresses clientConnectorAddresses() {
        return ClientConnectorAddresses.extractFromConfig((Config)Config.defaults(this.config));
    }

    @Override
    public String settingValue(String settingName) {
        return this.config.get(settingName);
    }

    @Override
    public Config config() {
        return this.memberConfig;
    }

    @Override
    public ThreadGroup threadGroup() {
        return this.threadGroup;
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    public File clusterStateDirectory() {
        return this.clusterStateDir;
    }

    public File raftLogDirectory() {
        return this.raftLogDir;
    }

    public void disableCatchupServer() throws Throwable {
        this.database.disableCatchupServer();
    }

    int discoveryPort() {
        return this.discoveryPort;
    }
}

