/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.core.HazelcastInstance;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.causalclustering.discovery.HazelcastInstanceNotActiveException;
import org.neo4j.causalclustering.discovery.RobustHazelcastWrapper;

public class RobustHazelcastWrapperTest {
    @Test
    public void shouldReconnectIfHazelcastConnectionInvalidated() throws Exception {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        HazelcastInstance hzInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hzInstance);
        RobustHazelcastWrapper hzWrapper = new RobustHazelcastWrapper(connector);
        hzWrapper.perform(hz -> {});
        ((HazelcastConnector)Mockito.verify((Object)connector, (VerificationMode)Mockito.times((int)1))).connectToHazelcast();
        try {
            hzWrapper.perform(hz -> {
                throw new com.hazelcast.core.HazelcastInstanceNotActiveException();
            });
            Assert.fail();
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        hzWrapper.perform(hz -> {});
        hzWrapper.perform(hz -> {});
        ((HazelcastConnector)Mockito.verify((Object)connector, (VerificationMode)Mockito.times((int)2))).connectToHazelcast();
    }
}

