/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.SharedDiscoveryCoreClient;
import org.neo4j.causalclustering.discovery.SharedDiscoveryReadReplicaClient;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;

public final class SharedDiscoveryService {
    private static final int MIN_DISCOVERY_MEMBERS = 2;
    private final ConcurrentMap<MemberId, CoreServerInfo> coreMembers = new ConcurrentHashMap<MemberId, CoreServerInfo>();
    private final ConcurrentMap<MemberId, ReadReplicaInfo> readReplicas = new ConcurrentHashMap<MemberId, ReadReplicaInfo>();
    private final List<SharedDiscoveryCoreClient> listeningClients = new CopyOnWriteArrayList<SharedDiscoveryCoreClient>();
    private final ConcurrentMap<String, ClusterId> clusterIdDbNames = new ConcurrentHashMap<String, ClusterId>();
    private final ConcurrentMap<String, LeaderInfo> leaderMap = new ConcurrentHashMap<String, LeaderInfo>();
    private final CountDownLatch enoughMembers = new CountDownLatch(2);

    SharedDiscoveryService() {
    }

    void waitForClusterFormation() throws InterruptedException {
        this.enoughMembers.await();
    }

    private boolean canBeBootstrapped(SharedDiscoveryCoreClient client) {
        Stream<SharedDiscoveryCoreClient> clientsWhoCanLeadForMyDb = this.listeningClients.stream().filter(c -> !c.refusesToBeLeader() && c.localDBName().equals(client.localDBName()));
        Optional<SharedDiscoveryCoreClient> firstAppropriateClient = clientsWhoCanLeadForMyDb.findFirst();
        return firstAppropriateClient.map(c -> c.equals(client)).orElse(false);
    }

    CoreTopology getCoreTopology(SharedDiscoveryCoreClient client) {
        String dbName = client.localDBName();
        boolean canBeBootstrapped = this.canBeBootstrapped(client);
        return this.getCoreTopology(dbName, canBeBootstrapped);
    }

    CoreTopology getCoreTopology(String dbName, boolean canBeBootstrapped) {
        return new CoreTopology((ClusterId)this.clusterIdDbNames.get(dbName), canBeBootstrapped, Collections.unmodifiableMap(this.coreMembers));
    }

    ReadReplicaTopology getReadReplicaTopology() {
        return new ReadReplicaTopology(Collections.unmodifiableMap(this.readReplicas));
    }

    void registerCoreMember(SharedDiscoveryCoreClient client) {
        CoreServerInfo previousMember = this.coreMembers.putIfAbsent(client.getMemberId(), client.getCoreServerInfo());
        if (previousMember == null) {
            this.listeningClients.add(client);
            this.enoughMembers.countDown();
            this.notifyCoreClients();
        }
    }

    void registerReadReplica(SharedDiscoveryReadReplicaClient client) {
        ReadReplicaInfo previousRR = this.readReplicas.putIfAbsent(client.getMemberId(), client.getReadReplicainfo());
        if (previousRR == null) {
            this.notifyCoreClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unRegisterCoreMember(SharedDiscoveryCoreClient client) {
        SharedDiscoveryService sharedDiscoveryService = this;
        synchronized (sharedDiscoveryService) {
            this.listeningClients.remove(client);
            this.coreMembers.remove(client.getMemberId());
        }
        this.notifyCoreClients();
    }

    void unRegisterReadReplica(SharedDiscoveryReadReplicaClient client) {
        this.readReplicas.remove(client.getMemberId());
        this.notifyCoreClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void casLeaders(LeaderInfo leaderInfo, String dbName) {
        ConcurrentMap<String, LeaderInfo> concurrentMap = this.leaderMap;
        synchronized (concurrentMap) {
            boolean sameTermButNoStepDown;
            Optional current = Optional.ofNullable(this.leaderMap.get(dbName));
            boolean sameLeader = current.map(LeaderInfo::memberId).equals(Optional.ofNullable(leaderInfo.memberId()));
            int termComparison = current.map(l -> Long.compare(l.term(), leaderInfo.term())).orElse(-1);
            boolean greaterTermExists = termComparison > 0;
            boolean bl = sameTermButNoStepDown = termComparison == 0 && !leaderInfo.isSteppingDown();
            if (!(greaterTermExists || sameTermButNoStepDown || sameLeader)) {
                this.leaderMap.put(dbName, leaderInfo);
            }
        }
    }

    boolean casClusterId(ClusterId clusterId, String dbName) {
        boolean success;
        ClusterId previousId = this.clusterIdDbNames.putIfAbsent(dbName, clusterId);
        boolean bl = success = previousId == null || previousId.equals((Object)clusterId);
        if (success) {
            this.notifyCoreClients();
        }
        return success;
    }

    Map<MemberId, RoleInfo> getCoreRoles() {
        Set dbNames = this.clusterIdDbNames.keySet();
        Set allLeaders = dbNames.stream().map(dbName -> Optional.ofNullable(this.leaderMap.get(dbName))).filter(Optional::isPresent).map(Optional::get).map(LeaderInfo::memberId).collect(Collectors.toSet());
        Function<MemberId, RoleInfo> roleMapper = m -> allLeaders.contains(m) ? RoleInfo.LEADER : RoleInfo.FOLLOWER;
        return this.coreMembers.keySet().stream().collect(Collectors.toMap(Function.identity(), roleMapper));
    }

    private synchronized void notifyCoreClients() {
        this.listeningClients.forEach(c -> {
            c.onCoreTopologyChange(this.getCoreTopology((SharedDiscoveryCoreClient)c));
            c.onReadReplicaTopologyChange(this.getReadReplicaTopology());
        });
    }
}

