/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import org.neo4j.causalclustering.helper.StateAwareSuspendableLifeCycle;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.lifecycle.Lifecycle;

class SuspendableLifecycleStateTestHelpers {
    SuspendableLifecycleStateTestHelpers() {
    }

    static void setInitialState(StateAwareSuspendableLifeCycle lifeCycle, LifeCycleState state) throws Throwable {
        for (LifeCycleState lifeCycleState : LifeCycleState.values()) {
            if (lifeCycleState.compareTo(state) > 0) continue;
            lifeCycleState.set((Lifecycle)lifeCycle);
        }
    }

    static enum SuspendedState {
        Untouched((ThrowingConsumer<Suspendable, Throwable>)((ThrowingConsumer)suspendable -> {})),
        Enabled((ThrowingConsumer<Suspendable, Throwable>)((ThrowingConsumer)Suspendable::enable)),
        Disabled((ThrowingConsumer<Suspendable, Throwable>)((ThrowingConsumer)Suspendable::disable));

        private final ThrowingConsumer<Suspendable, Throwable> consumer;

        private SuspendedState(ThrowingConsumer<Suspendable, Throwable> consumer) {
            this.consumer = consumer;
        }

        void set(Suspendable suspendable) throws Throwable {
            this.consumer.accept((Object)suspendable);
        }
    }

    static enum LifeCycleState {
        Init((ThrowingConsumer<Lifecycle, Throwable>)((ThrowingConsumer)Lifecycle::init)),
        Start((ThrowingConsumer<Lifecycle, Throwable>)((ThrowingConsumer)Lifecycle::start)),
        Stop((ThrowingConsumer<Lifecycle, Throwable>)((ThrowingConsumer)Lifecycle::stop)),
        Shutdown((ThrowingConsumer<Lifecycle, Throwable>)((ThrowingConsumer)Lifecycle::shutdown));

        private final ThrowingConsumer<Lifecycle, Throwable> operation;

        private LifeCycleState(ThrowingConsumer<Lifecycle, Throwable> operation) {
            this.operation = operation;
        }

        void set(Lifecycle lifecycle) throws Throwable {
            this.operation.accept((Object)lifecycle);
        }
    }
}

