/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import co.unruly.matchers.StreamMatchers;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.messaging.ReconnectingChannel;
import org.neo4j.causalclustering.messaging.ReconnectingChannels;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Pair;

public class ReconnectingChannelsTest {
    private ReconnectingChannels reconnectingChannels = new ReconnectingChannels();
    private AdvertisedSocketAddress to1 = new AdvertisedSocketAddress("host1", 1);
    private AdvertisedSocketAddress to2 = new AdvertisedSocketAddress("host2", 1);
    private ReconnectingChannel channel1 = (ReconnectingChannel)Mockito.mock(ReconnectingChannel.class);
    private ReconnectingChannel channel2 = (ReconnectingChannel)Mockito.mock(ReconnectingChannel.class);

    @Test
    public void shouldReturnEmptyStreamOfInstalledProtocolsIfNoChannels() {
        Stream installedProtocols = this.reconnectingChannels.installedProtocols();
        Assert.assertThat((Object)installedProtocols, (Matcher)StreamMatchers.empty());
    }

    @Test
    public void shouldReturnStreamOfInstalledProtocolsForChannelsThatHaveCompletedHandshake() {
        this.reconnectingChannels.putIfAbsent(this.to1, this.channel1);
        this.reconnectingChannels.putIfAbsent(this.to2, this.channel2);
        ProtocolStack protocolStack1 = new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_3, Collections.emptyList());
        ProtocolStack protocolStack2 = new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_2, Collections.emptyList());
        Mockito.when((Object)this.channel1.installedProtocolStack()).thenReturn(Optional.of(protocolStack1));
        Mockito.when((Object)this.channel2.installedProtocolStack()).thenReturn(Optional.of(protocolStack2));
        Stream installedProtocols = this.reconnectingChannels.installedProtocols();
        Stream<Pair> sorted = installedProtocols.sorted(Comparator.comparing(p -> ((AdvertisedSocketAddress)p.first()).getHostname()));
        Assert.assertThat(sorted, (Matcher)StreamMatchers.contains((Object[])new Pair[]{Pair.of((Object)this.to1, (Object)protocolStack1), Pair.of((Object)this.to2, (Object)protocolStack2)}));
    }

    @Test
    public void shouldExcludeChannelsWithoutInstalledProtocol() {
        this.reconnectingChannels.putIfAbsent(this.to1, this.channel1);
        this.reconnectingChannels.putIfAbsent(this.to2, this.channel2);
        ProtocolStack protocolStack1 = new ProtocolStack((Protocol.ApplicationProtocol)TestProtocols.TestApplicationProtocols.RAFT_3, Collections.emptyList());
        Mockito.when((Object)this.channel1.installedProtocolStack()).thenReturn(Optional.of(protocolStack1));
        Mockito.when((Object)this.channel2.installedProtocolStack()).thenReturn(Optional.empty());
        Stream installedProtocols = this.reconnectingChannels.installedProtocols();
        Assert.assertThat((Object)installedProtocols, (Matcher)StreamMatchers.contains((Object[])new Pair[]{Pair.of((Object)this.to1, (Object)protocolStack1)}));
    }
}

