/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.OutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.ports.allocation.PortAuthority;

public class ServerStateTest {
    private static Bootstrap bootstrap;
    private static EventLoopGroup clientGroup;
    private Server server;
    private Channel channel;

    @BeforeClass
    public static void initialSetup() {
        clientGroup = new NioEventLoopGroup();
        bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(clientGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) {
            }
        });
    }

    @Before
    public void setUp() throws Throwable {
        this.server = ServerStateTest.createServer();
        this.server.init();
        Assert.assertFalse((boolean)this.canConnect());
    }

    @After
    public void tearDown() throws Throwable {
        if (this.server != null) {
            this.server.stop();
            this.server.shutdown();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @AfterClass
    public static void finalTearDown() {
        clientGroup.shutdownGracefully();
    }

    @Test
    public void shouldStartServerNormally() throws Throwable {
        this.server.start();
        Assert.assertTrue((boolean)this.canConnect());
    }

    @Test
    public void canDisableAndEnableServer() throws Throwable {
        this.server.start();
        Assert.assertTrue((boolean)this.canConnect());
        this.server.disable();
        Assert.assertFalse((boolean)this.canConnect());
        this.server.enable();
        Assert.assertTrue((boolean)this.canConnect());
    }

    @Test
    public void serverCannotBeEnabledIfLifeCycleHasNotStarted() throws Throwable {
        this.server.enable();
        Assert.assertFalse((boolean)this.canConnect());
        this.server.start();
        Assert.assertTrue((boolean)this.canConnect());
    }

    @Test
    public void serverCannotStartIfDisabled() throws Throwable {
        this.server.disable();
        this.server.start();
        Assert.assertFalse((boolean)this.canConnect());
        this.server.enable();
        Assert.assertTrue((boolean)this.canConnect());
    }

    private static Server createServer() {
        return new Server(channel -> {}, (LogProvider)FormattedLogProvider.withDefaultLogLevel((Level)Level.DEBUG).toOutputStream((OutputStream)System.out), (LogProvider)FormattedLogProvider.withDefaultLogLevel((Level)Level.DEBUG).toOutputStream((OutputStream)System.out), new ListenSocketAddress("localhost", PortAuthority.allocatePort()), "serverName");
    }

    private boolean canConnect() throws InterruptedException {
        ListenSocketAddress socketAddress = this.server.address();
        ChannelFuture channelFuture = bootstrap.connect(socketAddress.getHostname(), socketAddress.getPort());
        this.channel = channelFuture.channel();
        return channelFuture.await().isSuccess();
    }
}

