/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServer;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ServerHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ServerMessage;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.collection.Iterators;

@RunWith(value=Parameterized.class)
public class HandshakeServerEnsureMagicTest {
    @Parameterized.Parameter
    public ServerMessage message;
    private final ApplicationSupportedProtocols supportedApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, TestProtocols.TestApplicationProtocols.listVersionsOf(Protocol.ApplicationProtocolCategory.RAFT));
    private Channel channel = (Channel)Mockito.mock(Channel.class);
    private ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedApplicationProtocol);
    private ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), Collections.emptyList());
    private HandshakeServer server = new HandshakeServer(this.applicationProtocolRepository, this.modifierProtocolRepository, this.channel);

    @Parameterized.Parameters(name="{0}")
    public static Collection<ServerMessage> data() {
        return Arrays.asList(new ApplicationProtocolRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), Iterators.asSet((Object[])new Integer[]{1, 2})), new ModifierProtocolRequest(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{"3", "4"})), new SwitchOverRequest(Protocol.ApplicationProtocolCategory.RAFT.canonicalName(), 2, Collections.emptyList()));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfMagicHasNotBeenSent() {
        this.message.dispatch((ServerMessageHandler)this.server);
    }

    @Test(expected=ServerHandshakeException.class)
    public void shouldCompleteExceptionallyIfMagicHasNotBeenSent() throws Throwable {
        try {
            this.message.dispatch((ServerMessageHandler)this.server);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.protocolStackFuture().getNow(null);
        }
        catch (CompletionException completion) {
            throw completion.getCause();
        }
    }

    @Test
    public void shouldNotThrowIfMagicHasBeenSent() {
        InitialMagicMessage.instance().dispatch((ServerMessageHandler)this.server);
        this.message.dispatch((ServerMessageHandler)this.server);
    }

    @Test
    public void shouldNotCompleteExceptionallyIfMagicHasBeenSent() {
        InitialMagicMessage.instance().dispatch((ServerMessageHandler)this.server);
        this.message.dispatch((ServerMessageHandler)this.server);
        try {
            this.server.protocolStackFuture().getNow(null);
        }
        catch (CompletionException ex) {
            Assert.assertThat((Object)ex.getMessage().toLowerCase(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"magic")));
        }
    }
}

