/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.neo4j.causalclustering.protocol.Protocol;

public interface TestProtocols {
    public static <U extends Comparable<U>, T extends Protocol<U>> T latest(Protocol.Category<T> category, T[] values) {
        return (T)Stream.of(values).filter(protocol -> protocol.category().equals(category.canonicalName())).max(Comparator.comparing(Protocol::implementation)).get();
    }

    public static <U extends Comparable<U>, T extends Protocol> U[] allVersionsOf(Protocol.Category<T> category, T[] values, IntFunction<U[]> constructor) {
        return (Comparable[])Stream.of(values).filter(protocol -> protocol.category().equals(category.canonicalName())).map(Protocol::implementation).toArray(constructor);
    }

    public static enum TestModifierProtocols implements Protocol.ModifierProtocol
    {
        SNAPPY(Protocol.ModifierProtocolCategory.COMPRESSION, "TestSnappy"),
        LZO(Protocol.ModifierProtocolCategory.COMPRESSION, "TestLZO"),
        LZ4(Protocol.ModifierProtocolCategory.COMPRESSION, "TestLZ4"),
        LZ4_VALIDATING(Protocol.ModifierProtocolCategory.COMPRESSION, "TestLZ4Validating"),
        LZ4_HIGH_COMPRESSION(Protocol.ModifierProtocolCategory.COMPRESSION, "TestLZ4High"),
        LZ4_HIGH_COMPRESSION_VALIDATING(Protocol.ModifierProtocolCategory.COMPRESSION, "TestLZ4HighValidating"),
        ROT13(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION, "ROT13"),
        NAME_CLASH(Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION, "TestSnappy");

        private final Protocol.ModifierProtocolCategory identifier;
        private final String friendlyName;

        private TestModifierProtocols(Protocol.ModifierProtocolCategory identifier, String friendlyName) {
            this.identifier = identifier;
            this.friendlyName = friendlyName;
        }

        public String category() {
            return this.identifier.canonicalName();
        }

        public String implementation() {
            return this.friendlyName;
        }

        public static Protocol.ModifierProtocol latest(Protocol.ModifierProtocolCategory identifier) {
            return (Protocol.ModifierProtocol)TestProtocols.latest((Protocol.Category)identifier, (Protocol[])TestModifierProtocols.values());
        }

        public static String[] allVersionsOf(Protocol.ModifierProtocolCategory identifier) {
            return (String[])TestProtocols.allVersionsOf((Protocol.Category)identifier, (Protocol[])TestModifierProtocols.values(), String[]::new);
        }

        public static List<String> listVersionsOf(Protocol.ModifierProtocolCategory identifier) {
            List<String> versions = Arrays.asList(TestModifierProtocols.allVersionsOf(identifier));
            versions.sort(Comparator.reverseOrder());
            return versions;
        }
    }

    public static enum TestApplicationProtocols implements Protocol.ApplicationProtocol
    {
        RAFT_1(Protocol.ApplicationProtocolCategory.RAFT, 1),
        RAFT_2(Protocol.ApplicationProtocolCategory.RAFT, 2),
        RAFT_3(Protocol.ApplicationProtocolCategory.RAFT, 3),
        RAFT_4(Protocol.ApplicationProtocolCategory.RAFT, 4),
        CATCHUP_1(Protocol.ApplicationProtocolCategory.CATCHUP, 1),
        CATCHUP_2(Protocol.ApplicationProtocolCategory.CATCHUP, 2),
        CATCHUP_3(Protocol.ApplicationProtocolCategory.CATCHUP, 3),
        CATCHUP_4(Protocol.ApplicationProtocolCategory.CATCHUP, 4);

        private final Integer version;
        private final Protocol.ApplicationProtocolCategory identifier;

        private TestApplicationProtocols(Protocol.ApplicationProtocolCategory identifier, int version) {
            this.identifier = identifier;
            this.version = version;
        }

        public String category() {
            return this.identifier.canonicalName();
        }

        public Integer implementation() {
            return this.version;
        }

        public static Protocol.ApplicationProtocol latest(Protocol.ApplicationProtocolCategory identifier) {
            return (Protocol.ApplicationProtocol)TestProtocols.latest((Protocol.Category)identifier, (Protocol[])TestApplicationProtocols.values());
        }

        public static Integer[] allVersionsOf(Protocol.ApplicationProtocolCategory identifier) {
            return (Integer[])TestProtocols.allVersionsOf((Protocol.Category)identifier, (Protocol[])TestApplicationProtocols.values(), Integer[]::new);
        }

        public static List<Integer> listVersionsOf(Protocol.ApplicationProtocolCategory identifier) {
            return Arrays.asList(TestApplicationProtocols.allVersionsOf(identifier));
        }
    }
}

