/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import co.unruly.matchers.OptionalMatchers;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.strategies.ConnectRandomlyToServerGroupStrategyImplTest;
import org.neo4j.causalclustering.upstream.strategies.ConnectRandomlyWithinServerGroupStrategy;
import org.neo4j.causalclustering.upstream.strategies.UserDefinedConfigurationStrategyTest;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ConnectRandomlyWithinServerGroupStrategyTest {
    @Test
    public void shouldUseServerGroupsFromConfig() {
        String myServerGroup = "my_server_group";
        Config configWithMyServerGroup = Config.defaults((Setting)CausalClusteringSettings.server_groups, (String)"my_server_group");
        Object[] myGroupMemberIds = UserDefinedConfigurationStrategyTest.memberIDs(10);
        TopologyService topologyService = ConnectRandomlyToServerGroupStrategyImplTest.getTopologyService(Collections.singletonList("my_server_group"), (MemberId[])myGroupMemberIds, Collections.singletonList("your_server_group"));
        ConnectRandomlyWithinServerGroupStrategy strategy = new ConnectRandomlyWithinServerGroupStrategy();
        strategy.inject(topologyService, configWithMyServerGroup, (LogProvider)NullLogProvider.getInstance(), myGroupMemberIds[0]);
        Optional result = strategy.upstreamDatabase();
        Assert.assertThat((Object)result, (Matcher)OptionalMatchers.contains((Matcher)Matchers.isIn((Object[])myGroupMemberIds)));
    }
}

