/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.net.ConnectException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.helpers.AdvertisedSocketAddress;

class CatchUpChannelPool<CHANNEL extends Channel> {
    private final Map<AdvertisedSocketAddress, LinkedList<CHANNEL>> idleChannels = new HashMap<AdvertisedSocketAddress, LinkedList<CHANNEL>>();
    private final Set<CHANNEL> activeChannels = new HashSet<CHANNEL>();
    private final Function<AdvertisedSocketAddress, CHANNEL> factory;

    CatchUpChannelPool(Function<AdvertisedSocketAddress, CHANNEL> factory) {
        this.factory = factory;
    }

    CHANNEL acquire(AdvertisedSocketAddress catchUpAddress) throws Exception {
        Object channel = this.getIdleChannel(catchUpAddress);
        if (channel == null) {
            channel = (Channel)this.factory.apply(catchUpAddress);
            try {
                channel.connect();
                this.assertActive(channel, catchUpAddress);
            }
            catch (Exception e) {
                channel.close();
                throw e;
            }
        }
        this.addActiveChannel(channel);
        return channel;
    }

    private void assertActive(CHANNEL channel, AdvertisedSocketAddress address) throws ConnectException {
        if (!channel.isActive()) {
            throw new ConnectException("Unable to connect to " + address);
        }
    }

    private synchronized CHANNEL getIdleChannel(AdvertisedSocketAddress catchUpAddress) {
        Channel channel = null;
        LinkedList<CHANNEL> channels = this.idleChannels.get(catchUpAddress);
        if (channels != null) {
            while ((channel = (Channel)channels.poll()) != null && !channel.isActive()) {
            }
            if (channels.isEmpty()) {
                this.idleChannels.remove(catchUpAddress);
            }
        }
        return (CHANNEL)channel;
    }

    private synchronized void addActiveChannel(CHANNEL channel) {
        this.activeChannels.add(channel);
    }

    private synchronized void removeActiveChannel(CHANNEL channel) {
        this.activeChannels.remove(channel);
    }

    void dispose(CHANNEL channel) {
        this.removeActiveChannel(channel);
        channel.close();
    }

    synchronized void release(CHANNEL channel) {
        this.removeActiveChannel(channel);
        this.idleChannels.computeIfAbsent(channel.destination(), address -> new LinkedList()).add(channel);
    }

    void close() {
        this.collectDisposed().forEach(Channel::close);
    }

    private synchronized Set<CHANNEL> collectDisposed() {
        Set disposed = Stream.concat(this.idleChannels.values().stream().flatMap(Collection::stream), this.activeChannels.stream()).collect(Collectors.toSet());
        this.idleChannels.clear();
        this.activeChannels.clear();
        return disposed;
    }

    static interface Channel {
        public AdvertisedSocketAddress destination();

        public void connect() throws Exception;

        public boolean isActive();

        public void close();
    }
}

