/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.neo4j.causalclustering.catchup.storecopy.CommitState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;

public class CommitStateHelper {
    private PageCache pageCache;
    private FileSystemAbstraction fs;
    private Config config;

    public CommitStateHelper(PageCache pageCache, FileSystemAbstraction fs, Config config) {
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
    }

    CommitState getStoreState(File storeDir) throws IOException {
        ReadOnlyTransactionIdStore metaDataStore = new ReadOnlyTransactionIdStore(this.pageCache, storeDir);
        long metaDataStoreTxId = metaDataStore.getLastCommittedTransactionId();
        Optional<Long> latestTransactionLogIndex = this.getLatestTransactionLogIndex(metaDataStoreTxId, storeDir);
        if (latestTransactionLogIndex.isPresent()) {
            return new CommitState(metaDataStoreTxId, latestTransactionLogIndex.get());
        }
        return new CommitState(metaDataStoreTxId);
    }

    /*
     * Exception decompiling
     */
    private Optional<Long> getLatestTransactionLogIndex(long startTxId, File storeDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasTxLogs(File storeDir) {
        File[] files = this.fs.listFiles(storeDir, TransactionLogFiles.DEFAULT_FILENAME_FILTER);
        if (files == null) {
            throw new RuntimeException("Files was null. Incorrect directory or I/O error?");
        }
        return files.length > 0;
    }
}

