/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class FileChunk {
    static final int MAX_SIZE = 8192;
    private static final int USE_MAX_SIZE_AND_EXPECT_MORE_CHUNKS = -1;
    private final int encodedLength;
    private final byte[] bytes;

    static FileChunk create(byte[] bytes, boolean last) {
        if (!last && bytes.length != 8192) {
            throw new IllegalArgumentException("All chunks except for the last must be of max size.");
        }
        return new FileChunk(last ? bytes.length : -1, bytes);
    }

    FileChunk(int encodedLength, byte[] bytes) {
        this.encodedLength = encodedLength;
        this.bytes = bytes;
    }

    public boolean isLast() {
        return this.encodedLength != -1;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int length() {
        return this.encodedLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileChunk fileChunk = (FileChunk)o;
        return this.encodedLength == fileChunk.encodedLength && Arrays.equals(this.bytes, fileChunk.bytes);
    }

    public int hashCode() {
        return Objects.hash(this.encodedLength, Arrays.hashCode(this.bytes));
    }

    public String toString() {
        return "FileChunk{" + Arrays.toString(this.bytes) + '}';
    }

    public static ChannelMarshal<FileChunk> marshal() {
        return Marshal.INSTANCE;
    }

    private static class Marshal
    extends SafeChannelMarshal<FileChunk> {
        private static final Marshal INSTANCE = new Marshal();

        private Marshal() {
        }

        @Override
        public void marshal(FileChunk fileChunk, WritableChannel channel) throws IOException {
            channel.putInt(fileChunk.encodedLength);
            byte[] bytes = fileChunk.bytes();
            channel.put(bytes, bytes.length);
        }

        @Override
        protected FileChunk unmarshal0(ReadableChannel channel) throws IOException {
            int encodedLength = channel.getInt();
            int length = encodedLength == -1 ? 8192 : encodedLength;
            byte[] bytes = new byte[length];
            channel.get(bytes, length);
            return new FileChunk(encodedLength, bytes);
        }
    }
}

