/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamProvider;
import org.neo4j.logging.Log;

public abstract class StoreCopyResponseAdaptors<T>
extends CatchUpResponseAdaptor<T> {
    private final StoreFileStreamProvider storeFileStreamProvider;
    private final Log log;
    private StoreFileStream storeFileStream;

    static StoreCopyResponseAdaptors<StoreCopyFinishedResponse> filesCopyAdaptor(StoreFileStreamProvider storeFileStreamProvider, Log log) {
        return new StoreFilesCopyResponseAdaptors(storeFileStreamProvider, log);
    }

    static StoreCopyResponseAdaptors<PrepareStoreCopyResponse> prepareStoreCopyAdaptor(StoreFileStreamProvider storeFileStreamProvider, Log log) {
        return new PrepareStoreCopyResponseAdaptors(storeFileStreamProvider, log);
    }

    private StoreCopyResponseAdaptors(StoreFileStreamProvider storeFileStreamProvider, Log log) {
        this.storeFileStreamProvider = storeFileStreamProvider;
        this.log = log;
    }

    @Override
    public void onFileHeader(CompletableFuture<T> requestOutcomeSignal, FileHeader fileHeader) {
        try {
            StoreFileStream fileStream = this.storeFileStreamProvider.acquire(fileHeader.fileName(), fileHeader.requiredAlignment());
            requestOutcomeSignal.whenComplete((BiConsumer)new CloseFileStreamOnComplete(fileStream, fileHeader.fileName()));
            this.storeFileStream = fileStream;
        }
        catch (Exception e) {
            requestOutcomeSignal.completeExceptionally(e);
        }
    }

    @Override
    public boolean onFileContent(CompletableFuture<T> signal, FileChunk fileChunk) {
        try {
            this.storeFileStream.write(fileChunk.bytes());
        }
        catch (Exception e) {
            signal.completeExceptionally(e);
        }
        return fileChunk.isLast();
    }

    private class CloseFileStreamOnComplete<RESPONSE>
    implements BiConsumer<RESPONSE, Throwable> {
        private final StoreFileStream fileStream;
        private String fileName;

        private CloseFileStreamOnComplete(StoreFileStream fileStream, String fileName) {
            this.fileStream = fileStream;
            this.fileName = fileName;
        }

        @Override
        public void accept(RESPONSE response, Throwable throwable) {
            try {
                this.fileStream.close();
            }
            catch (Exception e) {
                StoreCopyResponseAdaptors.this.log.error(String.format("Unable to close store file stream for file '%s'", this.fileName), (Throwable)e);
            }
        }
    }

    private static class StoreFilesCopyResponseAdaptors
    extends StoreCopyResponseAdaptors<StoreCopyFinishedResponse> {
        StoreFilesCopyResponseAdaptors(StoreFileStreamProvider storeFileStreamProvider, Log log) {
            super(storeFileStreamProvider, log);
        }

        @Override
        public void onFileStreamingComplete(CompletableFuture<StoreCopyFinishedResponse> signal, StoreCopyFinishedResponse response) {
            signal.complete(response);
        }
    }

    private static class PrepareStoreCopyResponseAdaptors
    extends StoreCopyResponseAdaptors<PrepareStoreCopyResponse> {
        PrepareStoreCopyResponseAdaptors(StoreFileStreamProvider storeFileStreamProvider, Log log) {
            super(storeFileStreamProvider, log);
        }

        @Override
        public void onStoreListingResponse(CompletableFuture<PrepareStoreCopyResponse> signal, PrepareStoreCopyResponse response) {
            signal.complete(response);
        }
    }
}

