/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.pagecache.PagedFile;

public class StreamToDisk
implements StoreFileStream {
    private WritableByteChannel writableByteChannel;
    private List<AutoCloseable> closeables;

    static StreamToDisk fromPagedFile(PagedFile pagedFile) throws IOException {
        return new StreamToDisk(pagedFile.openWritableByteChannel(), new AutoCloseable[]{pagedFile});
    }

    static StreamToDisk fromFile(FileSystemAbstraction fsa, File file) throws IOException {
        return new StreamToDisk((WritableByteChannel)fsa.open(file, OpenMode.READ_WRITE), new AutoCloseable[0]);
    }

    private StreamToDisk(WritableByteChannel writableByteChannel, AutoCloseable ... closeables) {
        this.writableByteChannel = writableByteChannel;
        this.closeables = new ArrayList<AutoCloseable>();
        this.closeables.add(writableByteChannel);
        this.closeables.addAll(Arrays.asList(closeables));
    }

    @Override
    public void write(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            this.writableByteChannel.write(buffer);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll(this.closeables);
    }
}

