/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;

public class TemporaryStoreDirectory
implements AutoCloseable {
    private static final String TEMP_COPY_DIRECTORY_NAME = "temp-copy";
    private final File tempStoreDir;
    private final StoreFiles storeFiles;
    private LogFiles tempLogFiles;

    public TemporaryStoreDirectory(FileSystemAbstraction fs, PageCache pageCache, File parent) throws IOException {
        this.tempStoreDir = new File(parent, TEMP_COPY_DIRECTORY_NAME);
        this.storeFiles = new StoreFiles(fs, pageCache, (directory, name) -> true);
        this.tempLogFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.tempStoreDir, (FileSystemAbstraction)fs).build();
        this.storeFiles.delete(this.tempStoreDir, this.tempLogFiles);
    }

    public File storeDir() {
        return this.tempStoreDir;
    }

    @Override
    public void close() throws IOException {
        this.storeFiles.delete(this.tempStoreDir, this.tempLogFiles);
    }
}

