/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import io.netty.channel.ChannelInboundHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.causalclustering.ReplicationModule;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.LeaderCanWrite;
import org.neo4j.causalclustering.core.RaftServerModule;
import org.neo4j.causalclustering.core.SupportedProtocolCreator;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.RaftProtocolClientInstaller;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.replication.ReplicationBenchmarkProcedure;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.server.CoreServerModule;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.ClusterStateException;
import org.neo4j.causalclustering.core.state.ClusteringModule;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachinesModule;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGeneratorFactory;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.procedures.ClusterOverviewProcedure;
import org.neo4j.causalclustering.discovery.procedures.CoreRoleProcedure;
import org.neo4j.causalclustering.discovery.procedures.InstalledProtocolsProcedure;
import org.neo4j.causalclustering.handlers.DuplexPipelineWrapperFactory;
import org.neo4j.causalclustering.handlers.PipelineWrapper;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.logging.BetterMessageLogger;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.logging.NullMessageLogger;
import org.neo4j.causalclustering.messaging.LoggingOutbound;
import org.neo4j.causalclustering.messaging.RaftOutbound;
import org.neo4j.causalclustering.messaging.SenderService;
import org.neo4j.causalclustering.net.InstalledProtocolHandler;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClientInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingPluginLoader;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.routing.load_balancing.procedure.GetServersProcedureForMultiDC;
import org.neo4j.causalclustering.routing.load_balancing.procedure.GetServersProcedureForSingleDC;
import org.neo4j.causalclustering.routing.load_balancing.procedure.LegacyGetServersProcedure;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.GetRoutersForAllDatabasesProcedure;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.GetRoutersForDatabaseProcedure;
import org.neo4j.causalclustering.upstream.NoOpUpstreamDatabaseStrategiesLoader;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategiesLoader;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseStrategySelector;
import org.neo4j.causalclustering.upstream.strategies.TypicallyConnectToRandomReadReplicaStrategy;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInProcedures;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.enterprise.StandardBoltConnectionTracker;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint.ConfigurableIOLimiter;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.DefaultKernelData;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.udc.UsageData;

public class EnterpriseCoreEditionModule
extends EditionModule {
    private final ConsensusModule consensusModule;
    private final ReplicationModule replicationModule;
    private final CoreTopologyService topologyService;
    protected final LogProvider logProvider;
    protected final Config config;
    private final Supplier<Stream<Pair<AdvertisedSocketAddress, ProtocolStack>>> clientInstalledProtocols;
    private final Supplier<Stream<Pair<SocketAddress, ProtocolStack>>> serverInstalledProtocols;
    private final CoreServerModule coreServerModule;
    private final CoreStateMachinesModule coreStateMachinesModule;

    private LoadBalancingProcessor getLoadBalancingProcessor() {
        try {
            return LoadBalancingPluginLoader.load(this.topologyService, this.consensusModule.raftMachine(), this.logProvider, this.config);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(EnterpriseBuiltInDbmsProcedures.class, true);
        procedures.registerProcedure(EnterpriseBuiltInProcedures.class, true);
        procedures.register((CallableProcedure)new LegacyGetServersProcedure(this.topologyService, this.consensusModule.raftMachine(), this.config, this.logProvider));
        if (((Boolean)this.config.get(CausalClusteringSettings.multi_dc_license)).booleanValue()) {
            procedures.register((CallableProcedure)new GetServersProcedureForMultiDC(this.getLoadBalancingProcessor()));
        } else {
            procedures.register((CallableProcedure)new GetServersProcedureForSingleDC(this.topologyService, this.consensusModule.raftMachine(), this.config, this.logProvider));
        }
        procedures.register((CallableProcedure)new GetRoutersForAllDatabasesProcedure(this.topologyService, this.config));
        procedures.register((CallableProcedure)new GetRoutersForDatabaseProcedure(this.topologyService, this.config));
        procedures.register((CallableProcedure)new ClusterOverviewProcedure(this.topologyService, this.logProvider));
        procedures.register((CallableProcedure)new CoreRoleProcedure(this.consensusModule.raftMachine()));
        procedures.register((CallableProcedure)new InstalledProtocolsProcedure(this.clientInstalledProtocols, this.serverInstalledProtocols));
        procedures.registerComponent(Replicator.class, x -> this.replicationModule.getReplicator(), false);
        procedures.registerProcedure(ReplicationBenchmarkProcedure.class);
    }

    public EnterpriseCoreEditionModule(PlatformModule platformModule, DiscoveryServiceFactory discoveryServiceFactory) {
        Dependencies dependencies = platformModule.dependencies;
        this.config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        File storeDir = platformModule.storeDir;
        LifeSupport life = platformModule.life;
        File dataDir = (File)this.config.get(GraphDatabaseSettings.data_directory);
        ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(dataDir, storeDir, false);
        try {
            clusterStateDirectory.initialize(fileSystem);
        }
        catch (ClusterStateException e) {
            throw new RuntimeException(e);
        }
        dependencies.satisfyDependency((Object)clusterStateDirectory);
        this.eligibleForIdReuse = IdReuseEligibility.ALWAYS;
        this.logProvider = logging.getInternalLogProvider();
        Supplier databaseHealthSupplier = dependencies.provideDependency(DatabaseHealth.class);
        this.watcherService = this.createFileSystemWatcherService(fileSystem, storeDir, logging, platformModule.jobScheduler, EnterpriseCoreEditionModule.fileWatcherFileNameFilter());
        dependencies.satisfyDependencies(new Object[]{this.watcherService});
        LogFiles logFiles = this.buildLocalDatabaseLogFiles(platformModule, fileSystem, storeDir);
        LocalDatabase localDatabase = new LocalDatabase(platformModule.storeDir, new StoreFiles(fileSystem, platformModule.pageCache), logFiles, platformModule.dataSourceManager, databaseHealthSupplier, this.watcherService, platformModule.availabilityGuard, this.logProvider);
        IdentityModule identityModule = new IdentityModule(platformModule, clusterStateDirectory.get());
        ClusteringModule clusteringModule = this.getClusteringModule(platformModule, discoveryServiceFactory, clusterStateDirectory, identityModule, dependencies);
        dependencies.satisfyDependency((Object)SslPolicyLoader.create((Config)this.config, (LogProvider)this.logProvider));
        PipelineWrapper clientPipelineWrapper = this.pipelineWrapperFactory().forClient(this.config, dependencies, this.logProvider, CausalClusteringSettings.ssl_policy);
        PipelineWrapper serverPipelineWrapper = this.pipelineWrapperFactory().forServer(this.config, dependencies, this.logProvider, CausalClusteringSettings.ssl_policy);
        PipelineWrapper backupServerPipelineWrapper = this.pipelineWrapperFactory().forServer(this.config, dependencies, this.logProvider, (Setting<String>)OnlineBackupSettings.ssl_policy);
        NettyPipelineBuilderFactory clientPipelineBuilderFactory = new NettyPipelineBuilderFactory(clientPipelineWrapper);
        NettyPipelineBuilderFactory serverPipelineBuilderFactory = new NettyPipelineBuilderFactory(serverPipelineWrapper);
        NettyPipelineBuilderFactory backupServerPipelineBuilderFactory = new NettyPipelineBuilderFactory(backupServerPipelineWrapper);
        this.topologyService = clusteringModule.topologyService();
        long logThresholdMillis = ((Duration)this.config.get(CausalClusteringSettings.unknown_address_logging_throttle)).toMillis();
        SupportedProtocolCreator supportedProtocolCreator = new SupportedProtocolCreator(this.config, this.logProvider);
        ApplicationSupportedProtocols supportedRaftProtocols = supportedProtocolCreator.createSupportedRaftProtocol();
        List<ModifierSupportedProtocols> supportedModifierProtocols = supportedProtocolCreator.createSupportedModifierProtocols();
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), supportedRaftProtocols);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), supportedModifierProtocols);
        ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Client>(Collections.singletonList(new RaftProtocolClientInstaller.Factory(clientPipelineBuilderFactory, this.logProvider)), ModifierProtocolInstaller.allClientInstallers);
        Duration handshakeTimeout = (Duration)this.config.get(CausalClusteringSettings.handshake_timeout);
        HandshakeClientInitializer channelInitializer = new HandshakeClientInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, clientPipelineBuilderFactory, handshakeTimeout, this.logProvider);
        SenderService raftSender = new SenderService(channelInitializer, this.logProvider);
        life.add((Lifecycle)raftSender);
        this.clientInstalledProtocols = raftSender::installedProtocols;
        MessageLogger<MemberId> messageLogger = this.createMessageLogger(this.config, life, identityModule.myself());
        RaftOutbound raftOutbound = new RaftOutbound(this.topologyService, raftSender, clusteringModule.clusterIdentity(), this.logProvider, logThresholdMillis);
        LoggingOutbound<MemberId, RaftMessages.RaftMessage> loggingOutbound = new LoggingOutbound<MemberId, RaftMessages.RaftMessage>(raftOutbound, identityModule.myself(), messageLogger);
        this.consensusModule = new ConsensusModule(identityModule.myself(), platformModule, loggingOutbound, clusterStateDirectory.get(), this.topologyService);
        dependencies.satisfyDependency((Object)this.consensusModule.raftMachine());
        this.replicationModule = new ReplicationModule(identityModule.myself(), platformModule, this.config, this.consensusModule, loggingOutbound, clusterStateDirectory.get(), fileSystem, this.logProvider);
        this.coreStateMachinesModule = new CoreStateMachinesModule(identityModule.myself(), platformModule, clusterStateDirectory.get(), this.config, this.replicationModule.getReplicator(), this.consensusModule.raftMachine(), dependencies, localDatabase);
        this.idTypeConfigurationProvider = this.coreStateMachinesModule.idTypeConfigurationProvider;
        this.createIdComponents(platformModule, dependencies, this.coreStateMachinesModule.idGeneratorFactory);
        dependencies.satisfyDependency((Object)this.idGeneratorFactory);
        dependencies.satisfyDependency((Object)this.idController);
        this.labelTokenHolder = this.coreStateMachinesModule.labelTokenHolder;
        this.propertyKeyTokenHolder = this.coreStateMachinesModule.propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = this.coreStateMachinesModule.relationshipTypeTokenHolder;
        this.lockManager = this.coreStateMachinesModule.lockManager;
        this.commitProcessFactory = this.coreStateMachinesModule.commitProcessFactory;
        this.accessCapability = new LeaderCanWrite(this.consensusModule.raftMachine());
        InstalledProtocolHandler serverInstalledProtocolHandler = new InstalledProtocolHandler();
        this.coreServerModule = new CoreServerModule(identityModule, platformModule, this.consensusModule, this.coreStateMachinesModule, clusteringModule, this.replicationModule, localDatabase, databaseHealthSupplier, clusterStateDirectory.get(), clientPipelineBuilderFactory, serverPipelineBuilderFactory, backupServerPipelineBuilderFactory, serverInstalledProtocolHandler);
        TypicallyConnectToRandomReadReplicaStrategy defaultStrategy = new TypicallyConnectToRandomReadReplicaStrategy(2);
        defaultStrategy.inject(this.topologyService, this.config, this.logProvider, identityModule.myself());
        UpstreamDatabaseStrategySelector catchupStrategySelector = this.createUpstreamDatabaseStrategySelector(identityModule.myself(), this.config, this.logProvider, this.topologyService, defaultStrategy);
        CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider catchupAddressProvider = new CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider(this.consensusModule.raftMachine(), this.topologyService, catchupStrategySelector);
        RaftServerModule.createAndStart(platformModule, this.consensusModule, identityModule, this.coreServerModule, localDatabase, serverPipelineBuilderFactory, messageLogger, catchupAddressProvider, supportedRaftProtocols, supportedModifierProtocols, (ChannelInboundHandler)serverInstalledProtocolHandler);
        this.serverInstalledProtocols = serverInstalledProtocolHandler::installedProtocols;
        this.editionInvariants(platformModule, dependencies, this.config, logging, life);
        dependencies.satisfyDependency((Object)this.lockManager);
        life.add((Lifecycle)this.coreServerModule.membershipWaiterLifecycle);
    }

    private UpstreamDatabaseStrategySelector createUpstreamDatabaseStrategySelector(MemberId myself, Config config, LogProvider logProvider, TopologyService topologyService, UpstreamDatabaseSelectionStrategy defaultStrategy) {
        UpstreamDatabaseStrategiesLoader loader;
        if (((Boolean)config.get(CausalClusteringSettings.multi_dc_license)).booleanValue()) {
            loader = new UpstreamDatabaseStrategiesLoader(topologyService, config, myself, logProvider);
            logProvider.getLog(((Object)((Object)this)).getClass()).info("Multi-Data Center option enabled.");
        } else {
            loader = new NoOpUpstreamDatabaseStrategiesLoader();
        }
        return new UpstreamDatabaseStrategySelector(defaultStrategy, loader, logProvider);
    }

    private LogFiles buildLocalDatabaseLogFiles(PlatformModule platformModule, FileSystemAbstraction fileSystem, File storeDir) {
        try {
            return LogFilesBuilder.activeFilesBuilder((File)storeDir, (FileSystemAbstraction)fileSystem, (PageCache)platformModule.pageCache).withConfig(this.config).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ClusteringModule getClusteringModule(PlatformModule platformModule, DiscoveryServiceFactory discoveryServiceFactory, ClusterStateDirectory clusterStateDirectory, IdentityModule identityModule, Dependencies dependencies) {
        return new ClusteringModule(discoveryServiceFactory, identityModule.myself(), platformModule, clusterStateDirectory.get());
    }

    protected DuplexPipelineWrapperFactory pipelineWrapperFactory() {
        return new VoidPipelineWrapperFactory();
    }

    protected void createIdComponents(PlatformModule platformModule, Dependencies dependencies, IdGeneratorFactory editionIdGeneratorFactory) {
        super.createIdComponents(platformModule, dependencies, editionIdGeneratorFactory);
        this.idGeneratorFactory = new FreeIdFilteredIdGeneratorFactory(this.idGeneratorFactory, this.coreStateMachinesModule.freeIdCondition);
    }

    static Predicate<String> fileWatcherFileNameFilter() {
        return Predicates.any((Predicate[])new Predicate[]{fileName -> fileName.startsWith("neostore.transaction.db"), fileName -> fileName.startsWith("index.db"), filename -> filename.startsWith("temp-copy"), filename -> filename.endsWith(".cacheprof")});
    }

    private MessageLogger<MemberId> createMessageLogger(Config config, LifeSupport life, MemberId myself) {
        MessageLogger<MemberId> messageLogger;
        if (((Boolean)config.get(CausalClusteringSettings.raft_messages_log_enable)).booleanValue()) {
            File logFile = (File)config.get(CausalClusteringSettings.raft_messages_log_path);
            messageLogger = (MessageLogger)life.add(new BetterMessageLogger<MemberId>(myself, EnterpriseCoreEditionModule.raftMessagesLog(logFile), Clocks.systemClock()));
        } else {
            messageLogger = new NullMessageLogger<MemberId>();
        }
        return messageLogger;
    }

    private void editionInvariants(PlatformModule platformModule, Dependencies dependencies, Config config, LogService logging, LifeSupport life) {
        this.statementLocksFactory = new StatementLocksFactorySelector(this.lockManager, config, logging).select();
        dependencies.satisfyDependency((Object)this.createKernelData(platformModule.fileSystem, platformModule.pageCache, platformModule.storeDir, config, (GraphDatabaseAPI)platformModule.graphDatabaseFacade, life));
        this.ioLimiter = new ConfigurableIOLimiter(platformModule.config);
        this.headerInformationFactory = this.createHeaderInformationFactory();
        this.schemaWriteGuard = this.createSchemaWriteGuard();
        this.transactionStartTimeout = ((Duration)config.get(GraphDatabaseSettings.transaction_start_timeout)).toMillis();
        this.constraintSemantics = new EnterpriseConstraintSemantics();
        this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(platformModule.availabilityGuard, this.transactionStartTimeout);
        this.registerRecovery(platformModule.databaseInfo, life, (DependencyResolver)dependencies);
        this.publishEditionInfo((UsageData)dependencies.resolveDependency(UsageData.class), platformModule.databaseInfo, config);
        dependencies.satisfyDependency((Object)this.createSessionTracker());
    }

    public boolean isLeader() {
        return this.consensusModule.raftMachine().currentRole() == Role.LEADER;
    }

    private static PrintWriter raftMessagesLog(File logFile) {
        logFile.getParentFile().mkdirs();
        try {
            return new PrintWriter(new FileOutputStream(logFile, true));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private SchemaWriteGuard createSchemaWriteGuard() {
        return SchemaWriteGuard.ALLOW_ALL_WRITES;
    }

    private KernelData createKernelData(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config, GraphDatabaseAPI graphAPI, LifeSupport life) {
        DefaultKernelData kernelData = new DefaultKernelData(fileSystem, pageCache, storeDir, config, graphAPI);
        return (KernelData)life.add((Lifecycle)kernelData);
    }

    private TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return () -> new TransactionHeaderInformation(-1, -1, new byte[0]);
    }

    private void registerRecovery(DatabaseInfo databaseInfo, LifeSupport life, DependencyResolver dependencyResolver) {
        life.addLifecycleListener((instance, from, to) -> {
            if (instance instanceof DatabaseAvailability && LifecycleStatus.STARTED.equals((Object)to)) {
                this.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
            }
        });
    }

    protected BoltConnectionTracker createSessionTracker() {
        return new StandardBoltConnectionTracker();
    }

    public void setupSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.setupEnterpriseSecurityModule((PlatformModule)platformModule, (Procedures)procedures);
    }

    public void disableCatchupServer() throws Throwable {
        this.coreServerModule.catchupServer().disable();
    }

    public static enum RaftLogImplementation {
        IN_MEMORY,
        SEGMENTED;

    }
}

