/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.EntryBasedLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.NoPruningPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.SizeBasedLogPruningStrategy;
import org.neo4j.function.Factory;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;
import org.neo4j.logging.LogProvider;

public class CoreLogPruningStrategyFactory
implements Factory<CoreLogPruningStrategy> {
    private final String pruningStrategyConfig;
    private final LogProvider logProvider;

    public CoreLogPruningStrategyFactory(String pruningStrategyConfig, LogProvider logProvider) {
        this.pruningStrategyConfig = pruningStrategyConfig;
        this.logProvider = logProvider;
    }

    public CoreLogPruningStrategy newInstance() {
        ThresholdConfigParser.ThresholdConfigValue thresholdConfigValue = ThresholdConfigParser.parse((String)this.pruningStrategyConfig);
        String type = thresholdConfigValue.type;
        long value = thresholdConfigValue.value;
        switch (type) {
            case "size": {
                return new SizeBasedLogPruningStrategy(value);
            }
            case "txs": 
            case "entries": {
                return new EntryBasedLogPruningStrategy(value, this.logProvider);
            }
            case "hours": 
            case "days": {
                throw new IllegalArgumentException("Time based pruning not supported yet for the segmented raft log, got '" + type + "'.");
            }
            case "false": {
                return new NoPruningPruningStrategy();
            }
        }
        throw new IllegalArgumentException("Invalid log pruning configuration value '" + value + "'. Invalid type '" + type + "', valid are files, size, txs, entries, hours, days.");
    }
}

