/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.LogPosition;
import org.neo4j.causalclustering.core.consensus.log.segmented.Reader;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.cursor.CursorValue;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;

class EntryRecordCursor
implements IOCursor<EntryRecord> {
    private ReadAheadChannel<StoreChannel> bufferedReader;
    private final LogPosition position;
    private final CursorValue<EntryRecord> currentRecord = new CursorValue();
    private final Reader reader;
    private ChannelMarshal<ReplicatedContent> contentMarshal;
    private final SegmentFile segment;
    private boolean hadError;
    private boolean closed;

    EntryRecordCursor(Reader reader, ChannelMarshal<ReplicatedContent> contentMarshal, long currentIndex, long wantedIndex, SegmentFile segment) throws IOException, EndOfStreamException {
        this.bufferedReader = new ReadAheadChannel(reader.channel());
        this.reader = reader;
        this.contentMarshal = contentMarshal;
        this.segment = segment;
        while (currentIndex < wantedIndex) {
            EntryRecord.read(this.bufferedReader, contentMarshal);
            ++currentIndex;
        }
        this.position = new LogPosition(currentIndex, this.bufferedReader.position());
    }

    public boolean next() throws IOException {
        EntryRecord entryRecord;
        try {
            entryRecord = EntryRecord.read(this.bufferedReader, this.contentMarshal);
        }
        catch (EndOfStreamException e) {
            this.currentRecord.invalidate();
            return false;
        }
        catch (IOException e) {
            this.hadError = true;
            throw e;
        }
        this.currentRecord.set((Object)entryRecord);
        this.position.byteOffset = this.bufferedReader.position();
        ++this.position.logIndex;
        return true;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        this.bufferedReader = null;
        this.closed = true;
        this.segment.refCount().decrease();
        if (this.hadError) {
            this.reader.close();
        } else {
            this.segment.positionCache().put(this.position);
            this.segment.readerPool().release(this.reader);
        }
    }

    public EntryRecord get() {
        return (EntryRecord)this.currentRecord.get();
    }
}

