/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.Reader;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ReaderPool {
    private ArrayList<Reader> pool;
    private final int maxSize;
    private final Log log;
    private final FileNames fileNames;
    private final FileSystemAbstraction fsa;
    private final Clock clock;

    ReaderPool(int maxSize, LogProvider logProvider, FileNames fileNames, FileSystemAbstraction fsa, Clock clock) {
        this.pool = new ArrayList(maxSize);
        this.maxSize = maxSize;
        this.log = logProvider.getLog(this.getClass());
        this.fileNames = fileNames;
        this.fsa = fsa;
        this.clock = clock;
    }

    Reader acquire(long version, long byteOffset) throws IOException {
        Reader reader = this.getFromPool(version);
        if (reader == null) {
            reader = this.createFor(version);
        }
        reader.channel().position(byteOffset);
        return reader;
    }

    void release(Reader reader) {
        reader.setTimeStamp(this.clock.millis());
        Optional<Reader> optionalOverflow = this.putInPool(reader);
        optionalOverflow.ifPresent(this::dispose);
    }

    private synchronized Reader getFromPool(long version) {
        Iterator<Reader> itr = this.pool.iterator();
        while (itr.hasNext()) {
            Reader reader = itr.next();
            if (reader.version() != version) continue;
            itr.remove();
            return reader;
        }
        return null;
    }

    private synchronized Optional<Reader> putInPool(Reader reader) {
        this.pool.add(reader);
        return this.pool.size() > this.maxSize ? Optional.of(this.pool.remove(0)) : Optional.empty();
    }

    private Reader createFor(long version) throws IOException {
        return new Reader(this.fsa, this.fileNames.getForVersion(version), version);
    }

    synchronized void prune(long maxAge, TimeUnit unit) {
        if (this.pool == null) {
            return;
        }
        long endTimeMillis = this.clock.millis() - unit.toMillis(maxAge);
        Iterator<Reader> itr = this.pool.iterator();
        while (itr.hasNext()) {
            Reader reader = itr.next();
            if (reader.getTimeStamp() >= endTimeMillis) continue;
            this.dispose(reader);
            itr.remove();
        }
    }

    private void dispose(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            this.log.error("Failed to close reader", (Throwable)e);
        }
    }

    synchronized void close() throws IOException {
        for (Reader reader : this.pool) {
            reader.close();
        }
        this.pool.clear();
        this.pool = null;
    }

    public synchronized void prune(long version) {
        if (this.pool == null) {
            return;
        }
        Iterator<Reader> itr = this.pool.iterator();
        while (itr.hasNext()) {
            Reader reader = itr.next();
            if (reader.version() != version) continue;
            this.dispose(reader);
            itr.remove();
        }
    }
}

