/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.state.ExposedRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class MembershipWaiter {
    private final MemberId myself;
    private final JobScheduler jobScheduler;
    private final Supplier<DatabaseHealth> dbHealthSupplier;
    private final long maxCatchupLag;
    private long currentCatchupDelayInMs;
    private final Log log;

    public MembershipWaiter(MemberId myself, JobScheduler jobScheduler, Supplier<DatabaseHealth> dbHealthSupplier, long maxCatchupLag, LogProvider logProvider) {
        this.myself = myself;
        this.jobScheduler = jobScheduler;
        this.dbHealthSupplier = dbHealthSupplier;
        this.maxCatchupLag = maxCatchupLag;
        this.currentCatchupDelayInMs = maxCatchupLag;
        this.log = logProvider.getLog(this.getClass());
    }

    CompletableFuture<Boolean> waitUntilCaughtUpMember(RaftMachine raft) {
        CompletableFuture<Boolean> catchUpFuture = new CompletableFuture<Boolean>();
        Evaluator evaluator = new Evaluator(raft, catchUpFuture, this.dbHealthSupplier);
        JobScheduler.JobHandle jobHandle = this.jobScheduler.schedule(new JobScheduler.Group(this.getClass().toString()), (Runnable)evaluator, this.currentCatchupDelayInMs, TimeUnit.MILLISECONDS);
        catchUpFuture.whenComplete((result, e) -> jobHandle.cancel(true));
        return catchUpFuture;
    }

    private class Evaluator
    implements Runnable {
        private final RaftMachine raft;
        private final CompletableFuture<Boolean> catchUpFuture;
        private long lastLeaderCommit;
        private final Supplier<DatabaseHealth> dbHealthSupplier;

        private Evaluator(RaftMachine raft, CompletableFuture<Boolean> catchUpFuture, Supplier<DatabaseHealth> dbHealthSupplier) {
            this.raft = raft;
            this.catchUpFuture = catchUpFuture;
            this.lastLeaderCommit = raft.state().leaderCommit();
            this.dbHealthSupplier = dbHealthSupplier;
        }

        @Override
        public void run() {
            if (!this.dbHealthSupplier.get().isHealthy()) {
                this.catchUpFuture.completeExceptionally(this.dbHealthSupplier.get().cause());
            } else if (this.iAmAVotingMember() && this.caughtUpWithLeader()) {
                this.catchUpFuture.complete(Boolean.TRUE);
            } else {
                MembershipWaiter.this.currentCatchupDelayInMs = MembershipWaiter.this.currentCatchupDelayInMs + TimeUnit.SECONDS.toMillis(1L);
                long longerDelay = MembershipWaiter.this.currentCatchupDelayInMs < MembershipWaiter.this.maxCatchupLag ? MembershipWaiter.this.currentCatchupDelayInMs : MembershipWaiter.this.maxCatchupLag;
                MembershipWaiter.this.jobScheduler.schedule(new JobScheduler.Group(MembershipWaiter.class.toString()), (Runnable)this, longerDelay, TimeUnit.MILLISECONDS);
            }
        }

        private boolean iAmAVotingMember() {
            Set<MemberId> votingMembers = this.raft.state().votingMembers();
            boolean votingMember = votingMembers.contains(MembershipWaiter.this.myself);
            if (!votingMember) {
                MembershipWaiter.this.log.debug("I (%s) am not a voting member: [%s]", new Object[]{MembershipWaiter.this.myself, votingMembers});
            }
            return votingMember;
        }

        private boolean caughtUpWithLeader() {
            boolean caughtUpWithLeader = false;
            ExposedRaftState state = this.raft.state();
            long localCommit = state.commitIndex();
            this.lastLeaderCommit = state.leaderCommit();
            if (this.lastLeaderCommit != -1L) {
                caughtUpWithLeader = localCommit == this.lastLeaderCommit;
                long gap = this.lastLeaderCommit - localCommit;
                MembershipWaiter.this.log.info("%s Catchup: %d => %d (%d behind)", new Object[]{MembershipWaiter.this.myself, localCommit, this.lastLeaderCommit, gap});
            } else {
                MembershipWaiter.this.log.info("Leader commit unknown");
            }
            return caughtUpWithLeader;
        }
    }
}

