/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import org.neo4j.causalclustering.core.consensus.schedule.Delay;
import org.neo4j.causalclustering.core.consensus.schedule.Timeout;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutHandler;
import org.neo4j.causalclustering.core.consensus.schedule.TimerService;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

public class Timer {
    private final TimerService.TimerName name;
    private final JobScheduler scheduler;
    private final Log log;
    private final JobScheduler.Group group;
    private final TimeoutHandler handler;
    private Timeout timeout;
    private Delay delay;
    private JobScheduler.JobHandle job;
    private long activeJobId;

    Timer(TimerService.TimerName name, JobScheduler scheduler, Log log, JobScheduler.Group group, TimeoutHandler handler) {
        this.name = name;
        this.scheduler = scheduler;
        this.log = log;
        this.group = group;
        this.handler = handler;
    }

    public synchronized void set(Timeout newTimeout) {
        this.delay = newTimeout.next();
        this.timeout = newTimeout;
        long jobId = this.newJobId();
        this.job = this.scheduler.schedule(this.group, () -> this.handle(jobId), this.delay.amount(), this.delay.unit());
    }

    private long newJobId() {
        ++this.activeJobId;
        return this.activeJobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(long jobId) {
        Timer timer = this;
        synchronized (timer) {
            if (this.activeJobId != jobId) {
                return;
            }
        }
        try {
            this.handler.onTimeout(this);
        }
        catch (Throwable e) {
            this.log.error(String.format("[%s] Handler threw exception", this.canonicalName()), e);
        }
    }

    public synchronized void reset() {
        if (this.timeout == null) {
            throw new IllegalStateException("You can't reset until you have set a timeout");
        }
        this.set(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(CancelMode cancelMode) {
        JobScheduler.JobHandle job;
        Timer timer = this;
        synchronized (timer) {
            ++this.activeJobId;
            job = this.job;
        }
        if (job != null) {
            try {
                if (cancelMode == CancelMode.SYNC_WAIT) {
                    job.waitTermination();
                } else if (cancelMode == CancelMode.ASYNC_INTERRUPT) {
                    job.cancel(true);
                }
            }
            catch (Exception e) {
                this.log.warn(String.format("[%s] Cancelling timer threw exception", this.canonicalName()), (Throwable)e);
            }
        }
    }

    public synchronized void invoke() {
        long jobId = this.newJobId();
        this.job = this.scheduler.schedule(this.group, () -> this.handle(jobId));
    }

    synchronized Delay delay() {
        return this.delay;
    }

    public TimerService.TimerName name() {
        return this.name;
    }

    private String canonicalName() {
        return this.name.getClass().getCanonicalName() + "." + this.name.name();
    }

    public static enum CancelMode {
        ASYNC,
        ASYNC_INTERRUPT,
        SYNC_WAIT;

    }
}

