/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.consensus.schedule.TimeoutHandler;
import org.neo4j.causalclustering.core.consensus.schedule.Timer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class TimerService {
    protected final JobScheduler scheduler;
    private final Collection<Timer> timers = new ArrayList<Timer>();
    private final Log log;

    public TimerService(JobScheduler scheduler, LogProvider logProvider) {
        this.scheduler = scheduler;
        this.log = logProvider.getLog(this.getClass());
    }

    public synchronized Timer create(TimerName name, JobScheduler.Group group, TimeoutHandler handler) {
        Timer timer = new Timer(name, this.scheduler, this.log, group, handler);
        this.timers.add(timer);
        return timer;
    }

    public synchronized Collection<Timer> getTimers(TimerName name) {
        return this.timers.stream().filter(timer -> timer.name().equals(name)).collect(Collectors.toList());
    }

    public synchronized void invoke(TimerName name) {
        this.getTimers(name).forEach(Timer::invoke);
    }

    public static interface TimerName {
        public String name();
    }
}

