/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.replication.BenchmarkResult;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ReplicationBenchmarkProcedure {
    @Context
    public Replicator replicator;
    @Context
    public SecurityContext securityContext;
    @Context
    public Log log;
    private static long startTime;
    private static List<Worker> workers;

    @Description(value="Start the benchmark.")
    @Procedure(name="dbms.cluster.benchmark.start", mode=Mode.DBMS)
    public synchronized void start(@Name(value="nThreads") Long nThreads, @Name(value="blockSize") Long blockSize) {
        this.checkSecurity();
        if (workers != null) {
            throw new IllegalStateException("Already running.");
        }
        this.log.info("Starting replication benchmark procedure");
        startTime = System.currentTimeMillis();
        workers = new ArrayList<Worker>(Math.toIntExact(nThreads));
        int i = 0;
        while ((long)i < nThreads) {
            Worker worker = new Worker(Math.toIntExact(blockSize));
            workers.add(worker);
            worker.start();
            ++i;
        }
    }

    @Description(value="Stop a running benchmark.")
    @Procedure(name="dbms.cluster.benchmark.stop", mode=Mode.DBMS)
    public synchronized Stream<BenchmarkResult> stop() throws InterruptedException {
        this.checkSecurity();
        if (workers == null) {
            throw new IllegalStateException("Not running.");
        }
        this.log.info("Stopping replication benchmark procedure");
        for (Worker worker : workers) {
            worker.stop();
        }
        for (Worker worker : workers) {
            worker.join();
        }
        long runTime = System.currentTimeMillis() - startTime;
        long totalRequests = 0L;
        long totalBytes = 0L;
        for (Worker worker : workers) {
            totalRequests += worker.totalRequests;
            totalBytes += worker.totalBytes;
        }
        workers = null;
        return Stream.of(new BenchmarkResult(totalRequests, totalBytes, runTime));
    }

    private void checkSecurity() throws AuthorizationViolationException {
        this.securityContext.assertCredentialsNotExpired();
        if (!this.securityContext.isAdmin()) {
            throw new AuthorizationViolationException("Permission denied.");
        }
    }

    private class Worker
    implements Runnable {
        private final int blockSize;
        long totalRequests;
        long totalBytes;
        private Thread t;
        private volatile boolean stopped;

        Worker(int blockSize) {
            this.blockSize = blockSize;
        }

        void start() {
            this.t = new Thread(this);
            this.t.start();
        }

        @Override
        public void run() {
            try {
                while (!this.stopped) {
                    Future<Object> future = ReplicationBenchmarkProcedure.this.replicator.replicate(new DummyRequest(new byte[this.blockSize]), true);
                    DummyRequest request = (DummyRequest)future.get();
                    ++this.totalRequests;
                    this.totalBytes += request.byteCount();
                }
            }
            catch (Throwable e) {
                ReplicationBenchmarkProcedure.this.log.error("Worker exception", e);
            }
        }

        void stop() {
            this.stopped = true;
        }

        void join() throws InterruptedException {
            this.t.join();
        }
    }
}

