/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import org.neo4j.function.ThrowingSupplier;

class Throttler {
    private final long creditLimit;
    private long currentCredit;

    Throttler(long creditLimit) {
        this.creditLimit = creditLimit;
    }

    private synchronized void acquire(long credits) throws InterruptedException {
        while (this.currentCredit >= this.creditLimit) {
            this.wait();
        }
        this.currentCredit += credits;
        if (this.currentCredit < this.creditLimit) {
            this.notify();
        }
    }

    private synchronized void release(long credits) {
        this.currentCredit -= credits;
        if (this.currentCredit < this.creditLimit) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R, E extends Exception> R invoke(ThrowingSupplier<R, E> call, long credits) throws E, InterruptedException {
        this.acquire(credits);
        try {
            Object object = call.get();
            return (R)object;
        }
        finally {
            this.release(credits);
        }
    }
}

