/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.server;

import io.netty.channel.ChannelInboundHandler;
import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.causalclustering.ReplicationModule;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupClientBuilder;
import org.neo4j.causalclustering.catchup.CatchupProtocolServerInstaller;
import org.neo4j.causalclustering.catchup.CatchupServerBuilder;
import org.neo4j.causalclustering.catchup.CheckpointerSupplier;
import org.neo4j.causalclustering.catchup.RegularCatchupServerHandler;
import org.neo4j.causalclustering.catchup.storecopy.CommitStateHelper;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.SupportedProtocolCreator;
import org.neo4j.causalclustering.core.TransactionBackupServiceProvider;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.pruning.PruningScheduler;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiter;
import org.neo4j.causalclustering.core.consensus.membership.MembershipWaiterLifecycle;
import org.neo4j.causalclustering.core.state.ClusteringModule;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CoreLife;
import org.neo4j.causalclustering.core.state.CoreSnapshotService;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.LongIndexMarshal;
import org.neo4j.causalclustering.core.state.RaftLogPruner;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachinesModule;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.helper.CompositeSuspendable;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.helper.Suspendable;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.causalclustering.net.InstalledProtocolHandler;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServerInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public class CoreServerModule {
    public static final String CLUSTER_ID_NAME = "cluster-id";
    public static final String LAST_FLUSHED_NAME = "last-flushed";
    public static final String DB_NAME = "db-name";
    public final MembershipWaiterLifecycle membershipWaiterLifecycle;
    private final Server catchupServer;
    private final Optional<Server> backupServer;
    private final IdentityModule identityModule;
    private final CoreStateMachinesModule coreStateMachinesModule;
    private final ConsensusModule consensusModule;
    private final ClusteringModule clusteringModule;
    private final LocalDatabase localDatabase;
    private final Supplier<DatabaseHealth> dbHealthSupplier;
    private final CommandApplicationProcess commandApplicationProcess;
    private final CoreSnapshotService snapshotService;
    private final CoreStateDownloaderService downloadService;
    private final Config config;
    private final JobScheduler jobScheduler;
    private final LogProvider logProvider;
    private final PlatformModule platformModule;

    public CoreServerModule(IdentityModule identityModule, PlatformModule platformModule, ConsensusModule consensusModule, CoreStateMachinesModule coreStateMachinesModule, ClusteringModule clusteringModule, ReplicationModule replicationModule, LocalDatabase localDatabase, Supplier<DatabaseHealth> dbHealthSupplier, File clusterStateDirectory, NettyPipelineBuilderFactory clientPipelineBuilderFactory, NettyPipelineBuilderFactory serverPipelineBuilderFactory, NettyPipelineBuilderFactory backupServerPipelineBuilderFactory, InstalledProtocolHandler installedProtocolsHandler) {
        this.identityModule = identityModule;
        this.coreStateMachinesModule = coreStateMachinesModule;
        this.consensusModule = consensusModule;
        this.clusteringModule = clusteringModule;
        this.localDatabase = localDatabase;
        this.dbHealthSupplier = dbHealthSupplier;
        this.platformModule = platformModule;
        this.config = platformModule.config;
        this.jobScheduler = platformModule.jobScheduler;
        Dependencies dependencies = platformModule.dependencies;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LifeSupport life = platformModule.life;
        this.logProvider = logging.getInternalLogProvider();
        LogProvider userLogProvider = logging.getUserLogProvider();
        CompositeSuspendable servicesToStopOnStoreCopy = new CompositeSuspendable();
        StateStorage lastFlushedStorage = (StateStorage)platformModule.life.add(new DurableStateStorage<Long>(platformModule.fileSystem, clusterStateDirectory, LAST_FLUSHED_NAME, new LongIndexMarshal(), (Integer)platformModule.config.get(CausalClusteringSettings.last_flushed_state_size), this.logProvider));
        consensusModule.raftMembershipManager().setRecoverFromIndexSupplier(lastFlushedStorage::getInitialState);
        CoreState coreState = new CoreState(coreStateMachinesModule.coreStateMachines, replicationModule.getSessionTracker(), lastFlushedStorage);
        Supplier databaseHealthSupplier = platformModule.dependencies.provideDependency(DatabaseHealth.class);
        this.commandApplicationProcess = new CommandApplicationProcess(consensusModule.raftLog(), (Integer)platformModule.config.get(CausalClusteringSettings.state_machine_apply_max_batch_size), (Integer)platformModule.config.get(CausalClusteringSettings.state_machine_flush_window_size), databaseHealthSupplier, this.logProvider, replicationModule.getProgressTracker(), replicationModule.getSessionTracker(), coreState, consensusModule.inFlightCache(), platformModule.monitors);
        platformModule.dependencies.satisfyDependency((Object)this.commandApplicationProcess);
        this.snapshotService = new CoreSnapshotService(this.commandApplicationProcess, coreState, consensusModule.raftLog(), consensusModule.raftMachine());
        CatchUpClient catchUpClient = this.createCatchupClient(clientPipelineBuilderFactory);
        CoreStateDownloader downloader = this.createCoreStateDownloader(servicesToStopOnStoreCopy, catchUpClient);
        this.downloadService = new CoreStateDownloaderService(platformModule.jobScheduler, downloader, this.commandApplicationProcess, this.logProvider, new ExponentialBackoffStrategy(1L, 30L, TimeUnit.SECONDS).newTimeout(), databaseHealthSupplier);
        this.membershipWaiterLifecycle = this.createMembershipWaiterLifecycle();
        SupportedProtocolCreator supportedProtocolCreator = new SupportedProtocolCreator(this.config, this.logProvider);
        ApplicationSupportedProtocols supportedCatchupProtocols = supportedProtocolCreator.createSupportedCatchupProtocol();
        List<ModifierSupportedProtocols> supportedModifierProtocols = supportedProtocolCreator.createSupportedModifierProtocols();
        ApplicationProtocolRepository catchupProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), supportedCatchupProtocols);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), supportedModifierProtocols);
        RegularCatchupServerHandler catchupServerHandler = new RegularCatchupServerHandler(platformModule.monitors, this.logProvider, localDatabase::storeId, platformModule.dependencies.provideDependency(TransactionIdStore.class), platformModule.dependencies.provideDependency(LogicalTransactionStore.class), localDatabase::dataSource, localDatabase::isAvailable, fileSystem, platformModule.pageCache, platformModule.storeCopyCheckPointMutex, this.snapshotService, new CheckpointerSupplier(platformModule.dependencies));
        CatchupProtocolServerInstaller.Factory catchupProtocolServerInstaller = new CatchupProtocolServerInstaller.Factory(serverPipelineBuilderFactory, this.logProvider, catchupServerHandler);
        ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server>(Collections.singletonList(catchupProtocolServerInstaller), ModifierProtocolInstaller.allServerInstallers);
        HandshakeServerInitializer handshakeServerInitializer = new HandshakeServerInitializer(catchupProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, serverPipelineBuilderFactory, this.logProvider);
        this.catchupServer = new CatchupServerBuilder(catchupServerHandler).serverHandler((ChannelInboundHandler)installedProtocolsHandler).catchupProtocols(supportedCatchupProtocols).modifierProtocols(supportedModifierProtocols).pipelineBuilder(serverPipelineBuilderFactory).userLogProvider(userLogProvider).debugLogProvider(this.logProvider).listenAddress((ListenSocketAddress)this.config.get(CausalClusteringSettings.transaction_listen_address)).serverName("catchup-server").build();
        TransactionBackupServiceProvider transactionBackupServiceProvider = new TransactionBackupServiceProvider(this.logProvider, userLogProvider, supportedCatchupProtocols, supportedModifierProtocols, backupServerPipelineBuilderFactory, catchupServerHandler, (ChannelInboundHandler)installedProtocolsHandler);
        this.backupServer = transactionBackupServiceProvider.resolveIfBackupEnabled(this.config);
        RaftLogPruner raftLogPruner = new RaftLogPruner(consensusModule.raftMachine(), this.commandApplicationProcess, (Clock)platformModule.clock);
        dependencies.satisfyDependency((Object)raftLogPruner);
        life.add((Lifecycle)new PruningScheduler(raftLogPruner, this.jobScheduler, ((Duration)this.config.get(CausalClusteringSettings.raft_log_pruning_frequency)).toMillis(), this.logProvider));
        servicesToStopOnStoreCopy.add(this.catchupServer);
        this.backupServer.ifPresent(servicesToStopOnStoreCopy::add);
    }

    private CatchUpClient createCatchupClient(NettyPipelineBuilderFactory clientPipelineBuilderFactory) {
        SupportedProtocolCreator supportedProtocolCreator = new SupportedProtocolCreator(this.config, this.logProvider);
        ApplicationSupportedProtocols supportedCatchupProtocols = supportedProtocolCreator.createSupportedCatchupProtocol();
        List<ModifierSupportedProtocols> supportedModifierProtocols = supportedProtocolCreator.createSupportedModifierProtocols();
        Duration handshakeTimeout = (Duration)this.config.get(CausalClusteringSettings.handshake_timeout);
        long inactivityTimeoutMillis = ((Duration)this.platformModule.config.get(CausalClusteringSettings.catch_up_client_inactivity_timeout)).toMillis();
        CatchUpClient catchUpClient = new CatchupClientBuilder(supportedCatchupProtocols, supportedModifierProtocols, clientPipelineBuilderFactory, handshakeTimeout, inactivityTimeoutMillis, this.logProvider, Clocks.systemClock()).build();
        this.platformModule.life.add((Lifecycle)catchUpClient);
        return catchUpClient;
    }

    private CoreStateDownloader createCoreStateDownloader(Suspendable servicesToSuspendOnStoreCopy, CatchUpClient catchUpClient) {
        ExponentialBackoffStrategy storeCopyBackoffStrategy = new ExponentialBackoffStrategy(1L, ((Duration)this.config.get(CausalClusteringSettings.store_copy_backoff_max_wait)).toMillis(), TimeUnit.MILLISECONDS);
        RemoteStore remoteStore = new RemoteStore(this.logProvider, this.platformModule.fileSystem, this.platformModule.pageCache, new StoreCopyClient(catchUpClient, this.platformModule.monitors, this.logProvider, storeCopyBackoffStrategy), new TxPullClient(catchUpClient, this.platformModule.monitors), new TransactionLogCatchUpFactory(), this.config, this.platformModule.monitors);
        CopiedStoreRecovery copiedStoreRecovery = (CopiedStoreRecovery)this.platformModule.life.add((Lifecycle)new CopiedStoreRecovery(this.platformModule.config, this.platformModule.kernelExtensions.listFactories(), this.platformModule.pageCache));
        StoreCopyProcess storeCopyProcess = new StoreCopyProcess(this.platformModule.fileSystem, this.platformModule.pageCache, this.localDatabase, copiedStoreRecovery, remoteStore, this.logProvider);
        CommitStateHelper commitStateHelper = new CommitStateHelper(this.platformModule.pageCache, this.platformModule.fileSystem, this.config);
        return new CoreStateDownloader(this.localDatabase, servicesToSuspendOnStoreCopy, remoteStore, catchUpClient, this.logProvider, storeCopyProcess, this.coreStateMachinesModule.coreStateMachines, this.snapshotService, commitStateHelper);
    }

    private MembershipWaiterLifecycle createMembershipWaiterLifecycle() {
        long electionTimeout = ((Duration)this.config.get(CausalClusteringSettings.leader_election_timeout)).toMillis();
        MembershipWaiter membershipWaiter = new MembershipWaiter(this.identityModule.myself(), this.jobScheduler, this.dbHealthSupplier, electionTimeout * 4L, this.logProvider);
        long joinCatchupTimeout = ((Duration)this.config.get(CausalClusteringSettings.join_catch_up_timeout)).toMillis();
        return new MembershipWaiterLifecycle(membershipWaiter, joinCatchupTimeout, this.consensusModule.raftMachine(), this.logProvider);
    }

    public Server catchupServer() {
        return this.catchupServer;
    }

    public Optional<Server> backupServer() {
        return this.backupServer;
    }

    public CoreLife createCoreLife(LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> handler) {
        return new CoreLife(this.consensusModule.raftMachine(), this.localDatabase, this.clusteringModule.clusterBinder(), this.commandApplicationProcess, this.coreStateMachinesModule.coreStateMachines, handler, this.snapshotService, this.downloadService);
    }

    public CommandApplicationProcess commandApplicationProcess() {
        return this.commandApplicationProcess;
    }

    public CoreStateDownloaderService downloadService() {
        return this.downloadService;
    }
}

