/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;

public class CoreBootstrapper {
    private static final long FIRST_INDEX = 0L;
    private static final long FIRST_TERM = 0L;
    private final File storeDir;
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogProvider logProvider;

    CoreBootstrapper(File storeDir, PageCache pageCache, FileSystemAbstraction fs, Config config, LogProvider logProvider) {
        this.storeDir = storeDir;
        this.pageCache = pageCache;
        this.fs = fs;
        this.config = config;
        this.logProvider = logProvider;
    }

    public CoreSnapshot bootstrap(Set<MemberId> members) throws IOException {
        StoreFactory factory = new StoreFactory(this.storeDir, this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, this.logProvider, EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = factory.openAllNeoStores(true);
        neoStores.close();
        CoreSnapshot coreSnapshot = new CoreSnapshot(0L, 0L);
        coreSnapshot.add(CoreStateType.ID_ALLOCATION, this.deriveIdAllocationState(this.storeDir));
        coreSnapshot.add(CoreStateType.LOCK_TOKEN, new ReplicatedLockTokenState());
        coreSnapshot.add(CoreStateType.RAFT_CORE_STATE, new RaftCoreState(new MembershipEntry(0L, members)));
        coreSnapshot.add(CoreStateType.SESSION_TRACKER, new GlobalSessionTrackerState());
        this.appendNullTransactionLogEntryToSetRaftIndexToMinusOne();
        return coreSnapshot;
    }

    private void appendNullTransactionLogEntryToSetRaftIndexToMinusOne() throws IOException {
        long dummyTransactionId;
        ReadOnlyTransactionIdStore readOnlyTransactionIdStore = new ReadOnlyTransactionIdStore(this.pageCache, this.storeDir);
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((File)this.storeDir, (FileSystemAbstraction)this.fs, (PageCache)this.pageCache).withConfig(this.config).withLastCommittedTransactionIdSupplier(() -> readOnlyTransactionIdStore.getLastClosedTransactionId() - 1L).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            FlushablePositionAwareChannel channel = logFiles.getLogFile().getWriter();
            TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((FlushableChannel)channel));
            long lastCommittedTransactionId = readOnlyTransactionIdStore.getLastCommittedTransactionId();
            PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(Collections.emptyList());
            byte[] txHeaderBytes = LogIndexTxHeaderEncoding.encodeLogIndexAsTxHeader(-1L);
            tx.setHeader(txHeaderBytes, -1, -1, -1L, lastCommittedTransactionId, -1L, -1);
            dummyTransactionId = lastCommittedTransactionId + 1L;
            writer.append((TransactionRepresentation)tx, dummyTransactionId);
            channel.prepareForFlush().flush();
        }
        File neoStoreFile = new File(this.storeDir, "neostore");
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)dummyTransactionId);
    }

    private IdAllocationState deriveIdAllocationState(File dbDir) {
        DefaultIdGeneratorFactory factory = new DefaultIdGeneratorFactory(this.fs);
        long[] highIds = new long[]{this.getHighId(dbDir, factory, IdType.NODE, ".nodestore.db"), this.getHighId(dbDir, factory, IdType.RELATIONSHIP, ".relationshipstore.db"), this.getHighId(dbDir, factory, IdType.PROPERTY, ".propertystore.db"), this.getHighId(dbDir, factory, IdType.STRING_BLOCK, ".propertystore.db.strings"), this.getHighId(dbDir, factory, IdType.ARRAY_BLOCK, ".propertystore.db.arrays"), this.getHighId(dbDir, factory, IdType.PROPERTY_KEY_TOKEN, ".propertystore.db.index"), this.getHighId(dbDir, factory, IdType.PROPERTY_KEY_TOKEN_NAME, ".propertystore.db.index.keys"), this.getHighId(dbDir, factory, IdType.RELATIONSHIP_TYPE_TOKEN, ".relationshiptypestore.db"), this.getHighId(dbDir, factory, IdType.RELATIONSHIP_TYPE_TOKEN_NAME, ".relationshiptypestore.db.names"), this.getHighId(dbDir, factory, IdType.LABEL_TOKEN, ".labeltokenstore.db"), this.getHighId(dbDir, factory, IdType.LABEL_TOKEN_NAME, ".labeltokenstore.db.names"), this.getHighId(dbDir, factory, IdType.NEOSTORE_BLOCK, ""), this.getHighId(dbDir, factory, IdType.SCHEMA, ".schemastore.db"), this.getHighId(dbDir, factory, IdType.NODE_LABELS, ".nodestore.db.labels"), this.getHighId(dbDir, factory, IdType.RELATIONSHIP_GROUP, ".relationshipgroupstore.db")};
        return new IdAllocationState(highIds, 0L);
    }

    private long getHighId(File coreDir, DefaultIdGeneratorFactory factory, IdType idType, String store) {
        IdGenerator idGenerator = factory.open(new File(coreDir, CoreBootstrapper.idFile(store)), idType, () -> -1L, Long.MAX_VALUE);
        long highId = idGenerator.getHighId();
        idGenerator.close();
        return highId;
    }

    private static String idFile(String store) {
        return "neostore" + store + ".id";
    }
}

