/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;

public class InFlightLogEntryReader
implements AutoCloseable {
    private final ReadableRaftLog raftLog;
    private final InFlightCache inFlightCache;
    private final boolean pruneAfterRead;
    private RaftLogCursor cursor;
    private boolean useCache = true;

    public InFlightLogEntryReader(ReadableRaftLog raftLog, InFlightCache inFlightCache, boolean pruneAfterRead) {
        this.raftLog = raftLog;
        this.inFlightCache = inFlightCache;
        this.pruneAfterRead = pruneAfterRead;
    }

    public RaftLogEntry get(long logIndex) throws IOException {
        RaftLogEntry entry = null;
        if (this.useCache) {
            entry = this.inFlightCache.get(logIndex);
        }
        if (entry == null) {
            this.useCache = false;
            entry = this.getUsingCursor(logIndex);
        }
        if (this.pruneAfterRead) {
            this.inFlightCache.prune(logIndex);
        }
        return entry;
    }

    private RaftLogEntry getUsingCursor(long logIndex) throws IOException {
        if (this.cursor == null) {
            this.cursor = this.raftLog.getEntryCursor(logIndex);
        }
        if (this.cursor.next()) {
            if (this.cursor.index() != logIndex) {
                throw new IllegalStateException(String.format("expected index %d but was %s", logIndex, this.cursor.index()));
            }
            return (RaftLogEntry)this.cursor.get();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

