/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.Optional;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloaderService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class RaftMessageApplier
implements LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
    private final LocalDatabase localDatabase;
    private final Log log;
    private final RaftMachine raftMachine;
    private final CoreStateDownloaderService downloadService;
    private final CommandApplicationProcess applicationProcess;
    private CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider catchupAddressProvider;

    public RaftMessageApplier(LocalDatabase localDatabase, LogProvider logProvider, RaftMachine raftMachine, CoreStateDownloaderService downloadService, CommandApplicationProcess applicationProcess, CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider catchupAddressProvider) {
        this.localDatabase = localDatabase;
        this.log = logProvider.getLog(this.getClass());
        this.raftMachine = raftMachine;
        this.downloadService = downloadService;
        this.applicationProcess = applicationProcess;
        this.catchupAddressProvider = catchupAddressProvider;
    }

    @Override
    public synchronized void handle(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> wrappedMessage) {
        try {
            ConsensusOutcome outcome = this.raftMachine.handle((RaftMessages.RaftMessage)wrappedMessage.message());
            if (outcome.needsFreshSnapshot()) {
                Optional<JobScheduler.JobHandle> downloadJob = this.downloadService.scheduleDownload(this.catchupAddressProvider);
                if (downloadJob.isPresent()) {
                    downloadJob.get().waitTermination();
                }
            } else {
                this.notifyCommitted(outcome.getCommitIndex());
            }
        }
        catch (Throwable e) {
            this.log.error("Error handling message", e);
            this.raftMachine.panic();
            this.localDatabase.panic(e);
        }
    }

    @Override
    public synchronized void start(ClusterId clusterId) {
    }

    @Override
    public synchronized void stop() {
    }

    private void notifyCommitted(long commitIndex) {
        this.applicationProcess.notifyCommitted(commitIndex);
    }
}

