/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.storageengine.api.ReadableChannel;

public class StateRecoveryManager<STATE> {
    protected final FileSystemAbstraction fileSystem;
    private final StateMarshal<STATE> marshal;

    public StateRecoveryManager(FileSystemAbstraction fileSystem, StateMarshal<STATE> marshal) {
        this.fileSystem = fileSystem;
        this.marshal = marshal;
    }

    public RecoveryStatus<STATE> recover(File fileA, File fileB) throws IOException {
        assert (fileA != null && fileB != null);
        STATE a = this.readLastEntryFrom(fileA);
        STATE b = this.readLastEntryFrom(fileB);
        if (a == null && b == null) {
            throw new IllegalStateException("no recoverable state");
        }
        if (a == null) {
            return new RecoveryStatus<STATE>(fileA, b);
        }
        if (b == null) {
            return new RecoveryStatus<STATE>(fileB, a);
        }
        if (this.marshal.ordinal(a) > this.marshal.ordinal(b)) {
            return new RecoveryStatus<STATE>(fileB, a);
        }
        return new RecoveryStatus<STATE>(fileA, b);
    }

    private STATE readLastEntryFrom(File file) throws IOException {
        try (ReadAheadChannel channel = new ReadAheadChannel(this.fileSystem.open(file, OpenMode.READ));){
            STATE result = null;
            try {
                Object lastRead;
                while ((lastRead = this.marshal.unmarshal((ReadableChannel)channel)) != null) {
                    result = lastRead;
                }
            }
            catch (EndOfStreamException endOfStreamException) {
                // empty catch block
            }
            STATE STATE = result;
            return STATE;
        }
    }

    public static class RecoveryStatus<STATE> {
        private final File activeFile;
        private final STATE recoveredState;

        RecoveryStatus(File activeFile, STATE recoveredState) {
            this.activeFile = activeFile;
            this.recoveredState = recoveredState;
        }

        public STATE recoveredState() {
            return this.recoveredState;
        }

        public File activeFile() {
            return this.activeFile;
        }
    }
}

