/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.core.state.snapshot.PersistentSnapshotDownloader;
import org.neo4j.causalclustering.helper.TimeoutStrategy;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class CoreStateDownloaderService
extends LifecycleAdapter {
    private final JobScheduler jobScheduler;
    private final CoreStateDownloader downloader;
    private final CommandApplicationProcess applicationProcess;
    private final Log log;
    private final TimeoutStrategy.Timeout downloaderPauseStrategy;
    private PersistentSnapshotDownloader currentJob;
    private JobScheduler.JobHandle jobHandle;
    private boolean stopped;
    private Supplier<DatabaseHealth> dbHealth;

    public CoreStateDownloaderService(JobScheduler jobScheduler, CoreStateDownloader downloader, CommandApplicationProcess applicationProcess, LogProvider logProvider, TimeoutStrategy.Timeout downloaderPauseStrategy, Supplier<DatabaseHealth> dbHealth) {
        this.jobScheduler = jobScheduler;
        this.downloader = downloader;
        this.applicationProcess = applicationProcess;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.downloaderPauseStrategy = downloaderPauseStrategy;
        this.dbHealth = dbHealth;
    }

    public synchronized Optional<JobScheduler.JobHandle> scheduleDownload(CatchupAddressProvider addressProvider) {
        if (this.stopped) {
            return Optional.empty();
        }
        if (this.currentJob == null || this.currentJob.hasCompleted()) {
            this.currentJob = new PersistentSnapshotDownloader(addressProvider, this.applicationProcess, this.downloader, this.log, this.downloaderPauseStrategy, this.dbHealth);
            this.jobHandle = this.jobScheduler.schedule(JobScheduler.Groups.downloadSnapshot, (Runnable)this.currentJob);
            return Optional.of(this.jobHandle);
        }
        return Optional.of(this.jobHandle);
    }

    public synchronized void stop() throws Throwable {
        this.stopped = true;
        if (this.currentJob != null) {
            this.currentJob.stop();
        }
    }

    public synchronized Optional<JobScheduler.JobHandle> downloadJob() {
        return Optional.ofNullable(this.jobHandle);
    }
}

