/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;

public class CoreTopology
implements Topology<CoreServerInfo> {
    static final CoreTopology EMPTY = new CoreTopology(null, false, Collections.emptyMap());
    private final ClusterId clusterId;
    private final boolean canBeBootstrapped;
    private final Map<MemberId, CoreServerInfo> coreMembers;

    public CoreTopology(ClusterId clusterId, boolean canBeBootstrapped, Map<MemberId, CoreServerInfo> coreMembers) {
        this.clusterId = clusterId;
        this.canBeBootstrapped = canBeBootstrapped;
        this.coreMembers = new HashMap<MemberId, CoreServerInfo>(coreMembers);
    }

    @Override
    public Map<MemberId, CoreServerInfo> members() {
        return this.coreMembers;
    }

    public ClusterId clusterId() {
        return this.clusterId;
    }

    public boolean canBeBootstrapped() {
        return this.canBeBootstrapped;
    }

    public String toString() {
        return String.format("{clusterId=%s, bootstrappable=%s, coreMembers=%s}", this.clusterId, this.canBeBootstrapped(), this.coreMembers);
    }

    public Optional<MemberId> randomCoreMemberId() {
        if (this.coreMembers.isEmpty()) {
            return Optional.empty();
        }
        return this.coreMembers.keySet().stream().skip(ThreadLocalRandom.current().nextInt(this.coreMembers.size())).findFirst();
    }

    public CoreTopology filterTopologyByDb(String dbName) {
        Map<MemberId, CoreServerInfo> filteredMembers = this.filterHostsByDb(this.members(), dbName);
        return new CoreTopology(this.clusterId(), this.canBeBootstrapped(), filteredMembers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreTopology that = (CoreTopology)o;
        return Objects.equals(this.coreMembers, that.coreMembers);
    }

    public int hashCode() {
        return Objects.hash(this.coreMembers);
    }
}

