/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.spi.properties.GroupProperty;
import java.util.logging.Level;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastClient;
import org.neo4j.causalclustering.discovery.HazelcastClientConnector;
import org.neo4j.causalclustering.discovery.HazelcastCoreTopologyService;
import org.neo4j.causalclustering.discovery.HazelcastLogging;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class HazelcastDiscoveryServiceFactory
implements DiscoveryServiceFactory {
    @Override
    public CoreTopologyService coreTopologyService(Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider, HostnameResolver hostnameResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy) {
        HazelcastDiscoveryServiceFactory.configureHazelcast(config, logProvider);
        return new HazelcastCoreTopologyService(config, myself, jobScheduler, logProvider, userLogProvider, hostnameResolver, topologyServiceRetryStrategy);
    }

    @Override
    public TopologyService topologyService(Config config, LogProvider logProvider, JobScheduler jobScheduler, MemberId myself, HostnameResolver hostnameResolver, TopologyServiceRetryStrategy topologyServiceRetryStrategy) {
        HazelcastDiscoveryServiceFactory.configureHazelcast(config, logProvider);
        return new HazelcastClient(new HazelcastClientConnector(config, logProvider, hostnameResolver), jobScheduler, logProvider, config, myself);
    }

    public static void configureHazelcast(Config config, LogProvider logProvider) {
        GroupProperty.PHONE_HOME_ENABLED.setSystemProperty("false");
        GroupProperty.SOCKET_BIND_ANY.setSystemProperty("false");
        GroupProperty.SHUTDOWNHOOK_ENABLED.setSystemProperty("false");
        String licenseKey = (String)config.get(CausalClusteringSettings.hazelcast_license_key);
        if (licenseKey != null) {
            GroupProperty.ENTERPRISE_LICENSE_KEY.setSystemProperty(licenseKey);
        }
        if (((Boolean)config.get(CausalClusteringSettings.disable_middleware_logging)).booleanValue()) {
            GroupProperty.LOGGING_TYPE.setSystemProperty("none");
        } else {
            HazelcastLogging.enable(logProvider, new HazelcastLogLevel(config));
        }
    }

    private static class HazelcastLogLevel
    extends Level {
        HazelcastLogLevel(Config config) {
            super("HAZELCAST", (Integer)config.get(CausalClusteringSettings.middleware_logging_level));
        }
    }
}

