/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.LogEvent;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogger;

public class HazelcastLogger
extends AbstractLogger {
    private final Log log;
    private final Level minLevel;

    HazelcastLogger(Log log, Level minLevel) {
        this.log = log;
        this.minLevel = minLevel;
    }

    public void log(Level level, String message) {
        this.getLogger(level).log(message);
    }

    public void log(Level level, String message, Throwable thrown) {
        this.getLogger(level).log(message, thrown);
    }

    public void log(LogEvent logEvent) {
        LogRecord logRecord = logEvent.getLogRecord();
        String message = "Member[" + logEvent.getMember() + "] " + logRecord.getMessage();
        Logger logger = this.getLogger(logRecord.getLevel());
        Throwable thrown = logRecord.getThrown();
        if (thrown == null) {
            logger.log(message);
        } else {
            logger.log(message, thrown);
        }
    }

    public Level getLevel() {
        return this.minLevel;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.minLevel.intValue();
    }

    private Logger getLogger(Level level) {
        int levelValue = level.intValue();
        if (levelValue < this.minLevel.intValue()) {
            return NullLogger.getInstance();
        }
        if (levelValue <= Level.FINE.intValue()) {
            return this.log.debugLogger();
        }
        if (levelValue <= Level.INFO.intValue()) {
            return this.log.infoLogger();
        }
        if (levelValue <= Level.WARNING.intValue()) {
            return this.log.warnLogger();
        }
        return this.log.errorLogger();
    }
}

