/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import org.neo4j.causalclustering.discovery.RetryStrategy;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class MultiRetryStrategy<INPUT, OUTPUT>
implements RetryStrategy<INPUT, OUTPUT> {
    private final long delayInMillis;
    private final long retries;
    private final LogProvider logProvider;
    private final LongConsumer sleeper;

    public MultiRetryStrategy(long delayInMillis, long retries, LogProvider logProvider, LongConsumer sleeper) {
        this.delayInMillis = delayInMillis;
        this.retries = retries;
        this.logProvider = logProvider;
        this.sleeper = sleeper;
    }

    @Override
    public OUTPUT apply(INPUT retriableInput, Function<INPUT, OUTPUT> retriable, Predicate<OUTPUT> wasRetrySuccessful) {
        Log log = this.logProvider.getLog(MultiRetryStrategy.class);
        OUTPUT result = retriable.apply(retriableInput);
        int currentIteration = 0;
        while (!wasRetrySuccessful.test(result) && (long)currentIteration++ < this.retries) {
            log.debug("Try attempt was unsuccessful for input: %s\n", new Object[]{retriableInput});
            this.sleeper.accept(this.delayInMillis);
            result = retriable.apply(retriableInput);
        }
        return result;
    }
}

